#include <stdlib.h>
#include "counter.h"

Counter* Counter_Alloc(void)
{
	return (Counter*)malloc(sizeof(Counter));
}

void Counter_Free(Counter* pMe)
{
	free(pMe);
}

Counter* Counter_Ctor(Counter* pMe)
{
    if(pMe)
    {
	    pMe->m_nValue__ = 0;
    }
	return pMe;
}

Counter* Counter_New(void)
{
	return Counter_Ctor(Counter_Alloc());
}

void Counter_Delete(Counter* pMe)
{
    Counter_Free(pMe);
}

int Counter_GetValue(Counter* pMe)
{
	return pMe->m_nValue__;
}

void Counter_SetValue(Counter* pMe,int value)
{
	pMe->m_nValue__ = value;
}

int Counter_Inc(Counter* pMe)
{
	pMe->m_nValue__++;
	return pMe->m_nValue__;
}

int Counter_Dec(Counter* pMe)
{
	pMe->m_nValue__--;
	return pMe->m_nValue__;
}

void Counter_Clr(Counter* pMe)
{
	pMe->m_nValue__ = 0;
}
