#include "act.h"
#include "actTestRunnerMfc.h"
#include "SimpleCalc.h"


SimpleCalc* pSimpleCalc;


static void setUp(void)
{
	pSimpleCalc = SimpleCalc_NewEx(2,1);
}

static void tearDown(void)
{
	SimpleCalc_Delete(pSimpleCalc);
}


static void testNewEx(void)
{
    int x,y;

    SimpleCalc_GetValue(pSimpleCalc, &x, &y);

	ACT_TEST_ASSERT_EQUAL_INT(2, x);
    ACT_TEST_ASSERT_EQUAL_INT(1, y);
}


ITest* SimpleCalcTest_tests()
{
    ACT_TESTCALLER_NEW(pCaller, "SimpleCalcTest_tests",setUp, tearDown);

    ACT_ADD_FIXTURE(pCaller, "testNewEx", testNewEx);
    
    return (ITest*) pCaller;
}

void TestRunner_Executor()
{
    /*
    IMfcTestRunner* pTestRunner;
    pTestRunner = IMfcTestRunner_New();

  	ITestRunner_start(pTestRunner);
		ITestRunner_addTest(pTestRunner, SimpleCalcTest_tests());
	ITestRunner_end(pTestRunner);
     */
    ITestRunnerMfc* pTestRunner;
    pTestRunner = ITestRunnerMfc_New();

    ITestRunnerMfc_start(pTestRunner);
    //__ITestRunnerMfc_start(pTestRunner);

        ITestRunnerMfc_addTest(pTestRunner, SimpleCalcTest_tests());
        ITestRunnerMfc_runTest(pTestRunner);
        
    
    ITestRunnerMfc_end(pTestRunner);

    ITestRunnerMfc_Delete(pTestRunner);
}
