#ifndef __ACTTESTFIXTURELIST_PRIVATE_H__
#define __ACTTESTFIXTURELIST_PRIVATE_H__

#include "acttestfixturelist.h"


struct __ITestNode {

	struct __ITestNode* pPrev;
	struct __ITestNode* pNext;
	ITest*               pData;
};


struct __ITestList
{
    ITestListVtbl         * pvt;
	int		nNodeCount; ///< number (default : 0)
	struct __ITestNode* 	lpNodeHead; ///< pointer to the node of head (default : null)
	struct __ITestNode*	lpNodeTail; ///< pointer to the node of tail(default: null)
};


static const ITest* List_GetHead(ITestList *pMe);
static const ITest* List_GetTail(ITestList *pMe);
static ITest* List_RemoveHead(ITestList *pMe, boolean bDataDelete) ;
static ITest* List_RemoveTail(ITestList *pMe, boolean bDataDelete);
static ITestNode* List_AddHead(ITestList *pMe, ITest* pData);
static ITestNode* List_AddTail(ITestList *pMe, ITest* pData);
static void List_RemoveAll(ITestList *pMe, boolean bDataDelete);
static const ITestNode* List_GetHeadPosition(ITestList *pMe);
static const ITestNode* List_GetTailPosition(ITestList *pMe);
static const ITest* List_GetNext(ITestList *pMe, ITestNode** ppPosition);
static const ITest* List_GetPrev(ITestList *pMe, ITestNode** ppPosition);
static const ITest* List_GetAt(ITestList *pMe, ITestNode* position);
static void List_SetAt(ITestList *pMe, ITestNode* pos, ITest* newElement, boolean bDeleteData);
static void List_RemoveAt(ITestList *pMe, ITestNode* position, boolean bDeleteData);
static ITestNode* List_InsertBefore(ITestList *pMe, ITestNode* pos, ITest* newElement);
static ITestNode* List_InsertAfter(ITestList *pMe, ITestNode* pos, ITest*newElement);
static const ITestNode* List_Find(ITestList *pMe, ITest* searchValue, ITestNode* startAfter);
static const ITestNode* List_FindIndex(ITestList *pMe, int nIndex);
static const int List_GetNo(ITestList *pMe, ITest* searchValue, ITestNode* startAfter);
static int List_GetCount(ITestList *pMe);
static boolean List_IsEmpty(ITestList *pMe);

#endif // __ACTTESTFIXTURELIST_PRIVATE_H__

