#include "act.h"
#include "actTests.h"

#ifdef ACT_STDLIB_TESTS
extern ITest* ACTStdLibTest_tests(void);
#endif

#ifdef ACT_ASSERT_TESTS
extern ITest* assertTest_tests(void);
#endif

#ifdef ACT_TESTCASE_TESTS
extern ITest* actTestCaseTest_tests(void);
#endif

#ifdef ACT_TESTRESULT_TESTS
extern ITest* TestResultTest_tests(void);
#endif

#ifdef ACT_TESTCALLER_TESTS
extern ITest* TestCallerTest_tests(void);
#endif

#ifdef ACT_TESTREPEAT_TESTS
extern ITest* TestRepeatTest_tests(void);
#endif


int main  (int argc, const char* argv[])
{
    ITestRunner* pTestRunner;

    //ITestRunner_Ctor(&trunner);
    pTestRunner = ITestRunner_New();
    ITestRunner_start(pTestRunner);

#ifdef ACT_STDLIB_TESTS
		ITestRunner_addTest(pTestRunner,ACTStdLibTest_tests());
#endif
#ifdef ACT_ASSERT_TESTS
		ITestRunner_addTest(pTestRunner,assertTest_tests());
#endif
#ifdef ACT_TESTCASE_TESTS
		ITestRunner_addTest(pTestRunner,actTestCaseTest_tests());
#endif
#ifdef ACT_TESTRESULT_TESTS
		ITestRunner_addTest(pTestRunner,TestResultTest_tests());
#endif
#ifdef ACT_TESTCALLER_TESTS
		ITestRunner_addTest(pTestRunner,TestCallerTest_tests());
#endif
#ifdef ACT_TESTREPEAT_TESTS
		ITestRunner_addTest(pTestRunner,TestRepeatTest_tests());
#endif
        ITestRunner_runTest(pTestRunner);

	ITestRunner_end(pTestRunner);
    ITestRunner_Delete(pTestRunner);
    return 0;
}
