package net.kldp.beat.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.kldp.beat.config.Config;
import net.kldp.beat.exception.ActionMappingException;

public class ActionServlet extends HttpServlet {

	public void destroy() {
		super.destroy();
	}

	@Override
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException,
			IOException {
		doGet(request, response);
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException,
			IOException {
		request.setCharacterEncoding("utf-8");
		response.setCharacterEncoding("utf-8");
		ActionMapper mapper = new ActionMapper(request.getServletPath());
		try {
			Object action = mapper.createAction();
			ActionService service = new ActionService(getServletContext(), request, response);
			service.doService(action, mapper);
		} catch (ActionMappingException e) {
			getServletContext().getRequestDispatcher(mapper.getDefaultView()).forward(request, response);
		}
	}

	public void init() throws ServletException {
		Config.load(getClass());
	}
}