/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.bugzilla.doc;

import com.wgshim.bugzilla.doc.WGResource;
import java.io.IOException;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class BugzillaShortDescHandler
extends DefaultHandler {
    private static final String SHORT_DESC_XPATH = WGResource.getInstance().getMessage("bugzilla.xml.short.desc.xpath");
    private static final String SHORT_DESC_ELE_NAME = SHORT_DESC_XPATH.substring(SHORT_DESC_XPATH.lastIndexOf("/") + 1, SHORT_DESC_XPATH.length());
    private boolean bShortDescFound = false;
    private Stack path = new Stack();
    private StringBuffer tempStr = new StringBuffer();

    public void parseBugzillaXMLData(String szXMLDoc) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser parser = saxParserFactory.newSAXParser();
        InputSource is = new InputSource(new StringReader(szXMLDoc));
        parser.parse(is, (DefaultHandler)this);
    }

    public String getResult() {
        return this.tempStr.toString();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.path.push(qName);
        if (qName.equals(SHORT_DESC_ELE_NAME) && this.isXPathEqual(this.path, SHORT_DESC_XPATH)) {
            this.bShortDescFound = true;
            this.tempStr = new StringBuffer();
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(SHORT_DESC_ELE_NAME) && this.isXPathEqual(this.path, SHORT_DESC_XPATH)) {
            this.bShortDescFound = false;
        }
        this.path.pop();
    }

    private boolean isXPathEqual(Stack path, String xpath) {
        Iterator i = ((AbstractList)path).iterator();
        StringBuffer sb = new StringBuffer("/");
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append("/");
        }
        return xpath.equals(sb.toString());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.bShortDescFound) {
            this.tempStr.append(new String(ch, start, length));
        }
    }

    private StringBuffer chopBothLineSeparator(StringBuffer sb) {
        int lIdx = -1;
        int rIdx = -1;
        int eIdx = -1;
        String tmp = sb.toString().trim();
        if ((sb = new StringBuffer(tmp)) == null || sb.length() == 0) {
            return sb;
        }
        rIdx = tmp.lastIndexOf(System.getProperty("line.separator"));
        eIdx = sb.toString().length() + System.getProperty("line.separator").length();
        if (rIdx >= 0) {
            sb.delete(rIdx, eIdx);
        }
        lIdx = tmp.indexOf(System.getProperty("line.separator"));
        eIdx = sb.toString().length() + System.getProperty("line.separator").length();
        if (lIdx >= 0) {
            sb.delete(lIdx, eIdx);
        }
        return sb;
    }
}

