/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.Util;
import com.sun.tools.doclets.VisibleMemberMap;
import com.wgshim.doclets.ConfigurationStandard;
import com.wgshim.doclets.Standard;
import com.wgshim.doclets.SubWriterHolderWriter;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSubWriter {
    protected final SubWriterHolderWriter writer;
    protected final ClassDoc classdoc;
    public VisibleMemberMap visibleMemberMap = null;
    public List visibleClasses = null;
    public boolean nodepr;

    public AbstractSubWriter(SubWriterHolderWriter writer, ClassDoc classdoc) {
        this.nodepr = Standard.configuration().nodeprecated;
        this.writer = writer;
        this.classdoc = classdoc;
        this.buildVisibleMemberMap();
    }

    public AbstractSubWriter(SubWriterHolderWriter writer) {
        this.nodepr = Standard.configuration().nodeprecated;
        this.writer = writer;
        this.classdoc = null;
    }

    public abstract int getMemberKind();

    public abstract void printSummaryLabel(ClassDoc var1);

    public abstract void printInheritedSummaryLabel(ClassDoc var1);

    public abstract void printSummaryAnchor(ClassDoc var1);

    public abstract void printInheritedSummaryAnchor(ClassDoc var1);

    protected abstract void printSummaryType(ProgramElementDoc var1);

    protected abstract void printSummaryLink(ClassDoc var1, ProgramElementDoc var2);

    protected abstract void printInheritedSummaryLink(ClassDoc var1, ProgramElementDoc var2);

    protected abstract void printHeader(ClassDoc var1);

    protected abstract void printBodyHtmlEnd(ClassDoc var1);

    protected abstract void printMember(ProgramElementDoc var1);

    protected abstract void printDeprecatedLink(ProgramElementDoc var1);

    protected abstract void printNavSummaryLink(ClassDoc var1, boolean var2);

    protected abstract void printNavDetailLink(boolean var1);

    protected void print(String str) {
        ((PrintWriter)((Object)this.writer)).print(str);
        this.writer.displayLength += str.length();
    }

    protected void print(char ch) {
        ((PrintWriter)((Object)this.writer)).print(ch);
        ++this.writer.displayLength;
    }

    protected void bold(String str) {
        this.writer.bold(str);
        this.writer.displayLength += str.length();
    }

    protected void printTypeLinkNoDimension(Type type) {
        ClassDoc cd = type.asClassDoc();
        if (cd == null) {
            this.print(type.typeName());
        } else {
            this.writer.printClassLink(cd);
        }
    }

    protected void printTypeLink(Type type) {
        this.printTypeLinkNoDimension(type);
        this.print(type.dimension());
    }

    protected String modifierString(MemberDoc member) {
        int ms = member.modifierSpecifier();
        int no = 288;
        return Modifier.toString(ms & ~no);
    }

    protected String typeString(MemberDoc member) {
        String type = "";
        if (member instanceof MethodDoc) {
            type = ((MethodDoc)member).returnType().toString();
        } else if (member instanceof FieldDoc) {
            type = ((FieldDoc)member).type().toString();
        }
        return type;
    }

    protected void printModifiers(MemberDoc member) {
        String mod = this.modifierString(member);
        if (mod.length() > 0) {
            this.print(mod);
            this.print(' ');
        }
    }

    protected void printTypedName(Type type, String name) {
        if (type != null) {
            this.printTypeLink(type);
        }
        if (name.length() > 0) {
            this.writer.space();
            ((PrintWriter)((Object)this.writer)).print(name);
        }
    }

    protected String makeSpace(int len) {
        if (len <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    protected void printStaticAndType(boolean isStatic, Type type) {
        this.writer.printTypeSummaryHeader();
        if (isStatic) {
            this.print("static");
        }
        this.writer.space();
        if (type != null) {
            this.printTypeLink(type);
        }
        this.writer.printTypeSummaryFooter();
    }

    protected void printModifierAndType(ProgramElementDoc member, Type type) {
        this.writer.printTypeSummaryHeader();
        this.printModifier(member);
        if (type == null) {
            if (member.isClass()) {
                this.print("class");
            } else {
                this.print("interface");
            }
        } else {
            this.printTypeLink(type);
        }
        this.writer.printTypeSummaryFooter();
    }

    protected void printModifier(ProgramElementDoc member) {
        if (member.isProtected()) {
            this.print("protected ");
        } else if (member.isPrivate()) {
            this.print("private ");
        } else if (!member.isPublic()) {
            this.writer.printText("doclet.Package_private");
            this.print(" ");
        }
        if (member.isMethod() && ((MethodDoc)member).isAbstract()) {
            this.print("abstract ");
        }
        if (member.isStatic()) {
            this.print("static");
        }
        this.writer.space();
    }

    protected void printComment(ProgramElementDoc member) {
        if (member.inlineTags().length > 0) {
            this.writer.dd();
            this.writer.printInlineComment((Doc)member);
        }
    }

    protected void printTags(ProgramElementDoc member) {
        Tag[] since = member.tags("since");
        if (member.seeTags().length + since.length > 0) {
            this.writer.dd();
            this.writer.dl();
            this.writer.printSeeTags((Doc)member);
            this.writer.printSinceTag((Doc)member);
            this.writer.dlEnd();
            this.writer.ddEnd();
        }
    }

    protected String name(ProgramElementDoc member) {
        return member.name();
    }

    protected void printDeprecated(ProgramElementDoc member) {
        Tag[] deprs = member.tags("deprecated");
        if (deprs.length > 0) {
            this.writer.dd();
            this.writer.boldText("doclet.Deprecated");
            this.writer.space();
            this.writer.printInlineDeprecatedComment(deprs[0]);
            this.writer.p();
        } else {
            this.printDeprecatedClassComment(member);
        }
    }

    protected void printDeprecatedClassComment(ProgramElementDoc member) {
        Tag[] deprs = member.containingClass().tags("deprecated");
        if (deprs.length > 0) {
            this.writer.dd();
            this.writer.boldText("doclet.Deprecated");
            this.writer.space();
        }
    }

    protected void printHead(MemberDoc member) {
        this.writer.h3();
        ((PrintWriter)((Object)this.writer)).print(member.name());
        this.writer.h3End();
    }

    protected void printFullComment(ProgramElementDoc member) {
        this.writer.dl();
        this.printDeprecated(member);
        this.printCommentAndTags(member);
        this.writer.dlEnd();
    }

    protected void printCommentAndTags(ProgramElementDoc member) {
        this.printComment(member);
        this.printTags(member);
    }

    public void printSummaryHeader(ClassDoc cd) {
        this.writer.printSummaryHeader(this, cd);
    }

    public void printInheritedSummaryHeader(ClassDoc cd) {
        this.writer.printInheritedSummaryHeader(this, cd);
    }

    public void printInheritedSummaryFooter(ClassDoc cd) {
        this.writer.printInheritedSummaryFooter(this, cd);
    }

    public void printSummaryFooter(ClassDoc cd) {
        this.writer.printSummaryFooter(this, cd);
    }

    public void printSummaryMember(ClassDoc cd, ProgramElementDoc member) {
        this.writer.printSummaryMember(this, cd, member);
    }

    public void printInheritedSummaryMember(ClassDoc cd, ProgramElementDoc member) {
        this.writer.printInheritedSummaryMember(this, cd, member);
    }

    public void printMembersSummary() {
        ArrayList members = new ArrayList(this.members(this.classdoc));
        if (members.size() > 0) {
            this.printSummaryHeader(this.classdoc);
            Collections.sort(members);
            int i = 0;
            while (i < members.size()) {
                this.printSummaryMember(this.classdoc, (ProgramElementDoc)members.get(i));
                ++i;
            }
            this.printSummaryFooter(this.classdoc);
        }
    }

    public void printInheritedMembersSummary() {
        int i = 0;
        while (i < this.visibleClasses.size()) {
            ArrayList inhmembers;
            ClassDoc inhclass = (ClassDoc)this.visibleClasses.get(i);
            if (inhclass != this.classdoc && (inhmembers = new ArrayList(this.members(inhclass))).size() > 0) {
                Collections.sort(inhmembers);
                this.printInheritedSummaryHeader(inhclass);
                this.printInheritedSummaryMember(inhclass, (ProgramElementDoc)inhmembers.get(0));
                int j = 1;
                while (j < inhmembers.size()) {
                    this.print(", ");
                    this.printInheritedSummaryMember(inhclass, (ProgramElementDoc)inhmembers.get(j));
                    ++j;
                }
                this.printInheritedSummaryFooter(inhclass);
            }
            ++i;
        }
    }

    public void printMembers() {
        List members = this.members(this.classdoc);
        if (members.size() > 0) {
            this.printHeader(this.classdoc);
            int i = 0;
            while (i < members.size()) {
                if (i > 0) {
                    this.writer.printMemberHeader();
                }
                ((PrintWriter)((Object)this.writer)).println("");
                this.printMember((ProgramElementDoc)members.get(i));
                this.writer.printMemberFooter();
                ++i;
            }
            this.printBodyHtmlEnd(this.classdoc);
        }
    }

    protected void printDeprecatedAPI(List deprmembers, String headingKey) {
        if (deprmembers.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableHeaderStart("#CCCCFF");
            this.writer.boldText(headingKey);
            this.writer.tableHeaderEnd();
            int i = 0;
            while (i < deprmembers.size()) {
                ProgramElementDoc member = (ProgramElementDoc)deprmembers.get(i);
                ClassDoc cd = member.containingClass();
                this.writer.trBgcolorStyle("white", "TableRowColor");
                this.writer.summaryRow(0);
                this.printDeprecatedLink(member);
                this.writer.br();
                this.writer.printNbsps();
                this.writer.printInlineDeprecatedComment(member.tags("deprecated")[0]);
                this.writer.space();
                this.writer.summaryRowEnd();
                this.writer.trEnd();
                ++i;
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void printUseInfo(Object mems, String heading) {
        if (mems == null) {
            return;
        }
        List members = (List)mems;
        if (members.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableUseInfoHeaderStart("#CCCCFF");
            ((PrintWriter)((Object)this.writer)).print(heading);
            this.writer.tableHeaderEnd();
            Iterator it = members.iterator();
            while (it.hasNext()) {
                ProgramElementDoc pgmdoc = (ProgramElementDoc)it.next();
                ClassDoc cd = pgmdoc.containingClass();
                this.writer.printSummaryLinkType(this, pgmdoc);
                if (cd != null && !(pgmdoc instanceof ConstructorDoc) && !(pgmdoc instanceof ClassDoc)) {
                    this.writer.bold(String.valueOf(cd.name()) + ".");
                }
                this.printSummaryLink(cd, pgmdoc);
                this.writer.printSummaryLinkComment(this, pgmdoc);
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void navSummaryLink() {
        List members = this.members(this.classdoc);
        if (members.size() > 0) {
            this.printNavSummaryLink(null, true);
            return;
        }
        ClassDoc icd = this.classdoc.superclass();
        while (icd != null) {
            List inhmembers = this.members(icd);
            if (inhmembers.size() > 0) {
                this.printNavSummaryLink(icd, true);
                return;
            }
            icd = icd.superclass();
        }
        this.printNavSummaryLink(null, false);
    }

    protected void navDetailLink() {
        List members = this.visibleMemberMap.getMembersFor(this.classdoc);
        this.printNavDetailLink(members.size() > 0);
    }

    protected void serialWarning(String key, String a1, String a2) {
        if (Standard.configuration().serialwarn) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.warning(key, a1, a2);
        }
    }

    public void buildVisibleMemberMap() {
        this.visibleMemberMap = new VisibleMemberMap(this.classdoc, this.getMemberKind(), this.nodepr);
        this.visibleClasses = this.visibleMemberMap.getVisibleClassesList();
    }

    public ProgramElementDoc[] eligibleMembers(ProgramElementDoc[] members) {
        return this.nodepr ? Util.excludeDeprecatedMembers((ProgramElementDoc[])members) : members;
    }

    public List members(ClassDoc cd) {
        return this.visibleMemberMap.getMembersFor(cd);
    }
}

