/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.IndexBuilder;
import com.sun.tools.doclets.Util;
import com.wgshim.doclets.ConfigurationStandard;
import com.wgshim.doclets.HtmlStandardWriter;
import com.wgshim.doclets.Standard;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class AllClassesFrameWriter
extends HtmlStandardWriter {
    protected IndexBuilder indexbuilder;

    public AllClassesFrameWriter(String filename, IndexBuilder indexbuilder) throws IOException, DocletAbortException {
        super(filename);
        this.indexbuilder = indexbuilder;
    }

    public static void generate(IndexBuilder indexbuilder) throws DocletAbortException {
        String filename = "allclasses-frame.html";
        try {
            AllClassesFrameWriter allclassgen = new AllClassesFrameWriter(filename, indexbuilder);
            allclassgen.generateAllClassesFile();
            ((PrintWriter)((Object)allclassgen)).close();
        }
        catch (IOException exc) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateAllClassesFile() throws IOException {
        String label = this.getText("doclet.All_Classes");
        this.printHeader(label);
        this.printAllClassesTableHeader();
        this.printAllClasses();
        this.printAllClassesTableFooter();
        this.printBodyHtmlEnd();
    }

    protected void printAllClasses() {
        int i = 0;
        while (i < this.indexbuilder.elements().length) {
            Character unicode = (Character)this.indexbuilder.elements()[i];
            this.generateContents(this.indexbuilder.getMemberList(unicode));
            ++i;
        }
    }

    protected void generateContents(List classlist) {
        int i = 0;
        while (i < classlist.size()) {
            ClassDoc cd = (ClassDoc)classlist.get(i);
            if (Util.isCoreClass((ClassDoc)cd)) {
                String label = this.italicsClassName(cd, false);
                this.printTargetHyperLink(this.pathToClass(cd), "classFrame", label);
                this.br();
            }
            ++i;
        }
    }

    protected void printAllClassesTableHeader() {
        this.fontSizeStyle("+1", "FrameHeadingFont");
        this.boldText("doclet.All_Classes");
        this.fontEnd();
        this.br();
        this.table();
        this.tr();
        this.tdNowrap();
        this.fontStyle("FrameItemFont");
    }

    protected void printAllClassesTableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }
}

