<?php // -*-php-*-
rcs_id('$Id: RecentChanges.php,v 1.3 2004/03/25 08:15:44 gryu Exp $');
/**
 */
class WikiPlugin_RecentChanges
extends	WikiPlugin
{
	var	$name =	'RecentChanges';
	
	function getDefaultArguments() {
		return array('days' => 2,
			'show_minor'	=> false,
			 'show_major'	=> true,
			 'show_all'	=> false);
	}

	function run($dbi, $argstr,	$request) {
		extract($this->getArgs($argstr,	$request));
		$params	= array('include_minor_revisions' => $show_minor,
			'exclude_major_revisions' => !$show_major,
			'include_all_revisions'	=> $show_all);
		if ($days >	0.0) {
			$params['since'] = time() -	24 * 3600 *	$days;
			$html =	sprintf(_T('changed_since'), $days);
		}
		else {
			$html =	'<h3>'. _T('all_changes'). "</h3>\n";
		}
			 
		$changes = $dbi->mostRecent($params);

		global $dateformat;
		global $WikiNameRegexp;
		
		$last_date = '';
		$lines = array();

		$diffargs =	array('action' => 'diff');

		$html .= '<table width="100%" border="0" class="recent">';
	
		while ($rev	= $changes->next())	{
			$created = $rev->get('mtime');
			$date =	strftime($dateformat, $created);
			$time =	strftime("%I:%M %p", $created);	// Make	configurable.
			if ($date != $last_date) {
				if ($lines)	{
					$html .= join("\n",	$lines);
					$lines = array();
				}
				$html .= '<tr><td colspan="3">&nbsp;</td></tr><tr><td colspan="3">'. QElement('h4', $date). '</td></tr>';				
				$last_date = $date;
			}
			
			$page =	$rev->getPage();
			$pagename =	$page->getName();

			if ($show_all) {
				// FIXME: should set previous, too,	if showing only	minor or major revs.
				//	or maybe difftype.
				$diffargs['version'] = $rev->getVersion();
			}
			if ($show_major)
				$diffargs['previous'] = 'major';

			$diff =	QElement('a',  array('href' => WikiURL($pagename,	$diffargs)),
				 '(' . _T("diff") . ')'  );	//gryu*
			
			$wikipage =	LinkWikiWord($page->getName());

			$author	= $rev->get('author');
			if (preg_match("/^$WikiNameRegexp\$/", $author))
				$author	= LinkWikiWord($author);
			elseif (preg_match("/(\[\s*)(.+?)(\s*\])/",	$author, $tmp_match)) //gryu+
				$author	= LinkWikiWord(htmlspecialchars($tmp_match[2])); //gryu+
			else
				$author	= htmlspecialchars($author);

			$summary = htmlspecialchars($rev->get('summary')); 
			if ($summary)
				$summary = ' ... '. $summary;
			$lines[] = "<tr>\n<td width='40%'>$diff $wikipage</td>\n<td width='10%'>$time</td>\n<td with='20%'>$author $summary</td>\n</tr>\n"; //gryu*
		}

		if ($lines)
			$html .= join("\n", $lines);

		$html .= '</table>';
		return $html;
	}
};
		
// (c-file-style: "gnu")
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:	  
?>