<?php // -*-php-*-
ini_set('display_errors', 1);
if (!function_exists('html_entity_decode'))
{
	function html_entity_decode( $given_html, $quote_style = ENT_QUOTES ) {
   		$trans_table = array_flip(get_html_translation_table( HTML_SPECIALCHARS, $quote_style ));
   		$trans_table['&#39;'] = "'";
   		return ( strtr( $given_html, $trans_table ) );
	}
}

function get_remote_file($url)
{
   $url_parsed = parse_url($url);
   $host = $url_parsed["host"];
   $port = $url_parsed["port"];
   if ($port==0)
       $port = 80;
   $path = $url_parsed["path"];
   if ($url_parsed["query"] != "")
       $path .= "?".$url_parsed["query"];

   $out = "GET $path HTTP/1.0\r\nHost: $host\r\n\r\n";

   $fp = fsockopen($host, $port, $errno, $errstr, 30);

   fwrite($fp, $out);
   $body = false;
   while (!feof($fp)) {
       $s = fgets($fp, 1024);
       if ( $body )
           $in .= $s;
       if ( $s == "\r\n" )
           $body = true;
   }
  
   fclose($fp);
  
   return $in;	
}

function no_encoding($str)
{
	return $str;
}

function do_encoding($str)
{
	if (!function_exists('iconv')) return $str;
	$result = iconv('utf-8', 'euc-kr', $str);
	if ($result)
		return $result;
	else
		return $str;
}

function getFeed($source, &$templates)
{
    $tplSite = $templates['Site'];
    $tplList = $templates['List'];
    $tplItem = $templates['Item'];
    $feed = get_remote_file($source);
   
    $feed = str_replace(array("\r\n", "\n", '<![CDATA[', ']]>'), '', $feed);
    $html = '';

    @$enc_func = no_encoding;
    if( preg_match("/<?xml(.*)encoding[\s\=]+[\"\'](.*)[\"\']/U", $feed, $match) )
    {
    	if (strtolower($match[2]) == 'utf-8')
		@$enc_func= do_encoding;
    }
   
    if( preg_match('#<channel(.*)<item#U', $feed, $match) )
    {
        $channel = $match[1];
        if ( preg_match('#<title>(.*)</title>#U', $channel, $match) )
        {
            
            $title = $enc_func($match[1]);
        }
    
        if(preg_match('#<link>(.*)</link>#U', $channel, $match) )
        {
            $url = $match[1];
        }
    
        if(preg_match('#<description>(.*)</description>#U', $channel, $match) )
        {
            $desc = $enc_func(stripslashes($match[1]));
        }
    } //if

    $html .= str_replace( array( '{TITLE}', '{URL}', '{DESC}' ), 
            array( $title, $url, $desc) , $tplSite);
    preg_match_all('#<item[^s](.*)</item>#U', $feed, $matches);
    $list = '';
    foreach($matches[1] as $item)
    {
        $title='';
        $url='';
        $date='';
        $desc='';
        if(preg_match('#<title>(.*)</title>#', $item, $match) )
        {
          $title= $enc_func(stripslashes($match[1]));
        }
        
        if(preg_match('#<link>(.*)</link>#', $item, $match) )
        {
          $url= $match[1];
        }
        if(preg_match('#<pubDate>(.*)</pubDate>#', $item, $match) )
        {
          $date= $match[1];
        }
        if(preg_match('#<dc:date>(.*)</dc:date>#', $item, $match) )
        {
          $date= $match[1];
        }
        
        if(preg_match('#<description>(.*)</description>#', $item, $match) )
        {
        	if ($_GET['usehtml']) $match[1]=html_entity_decode($match[1]);
          	$desc= $enc_func($match[1]);
        }
        $list .= str_replace( array( '{TITLE}', '{URL}', '{DATE}', '{DESC}' ), 
            array( $title, $url, $date, $desc) , $tplItem);
    }
    $html .= str_replace( '{LIST}', $list, $tplList); 

    return $html;
} // function getFeed

$DefaultArguments  = 
    array('source'=> '', 'showdesc'=>false, 'showdate'=>false, 'usehtml' => false );

extract($_GET); 

if( $source == '' )
{
    return '<div class="errors">RdfFeed ÷ : source Ű RDF  URL  ּ. </div>';
}
$tplSite = <<<__TEMPLATE__
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
  "http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=euc-kr">
<link rel="stylesheet" title="phpwiki" href="/phpwiki/phpwiki.css" type="text/css">
</head>
<body>
<table class="recent" width="100%" style="border:solid;border-width:1px;border-color:#0000FF;">
<tr><td><h3><a href="{URL}" target="_top">{TITLE}</a></h3>{DESC}</td></tr>
__TEMPLATE__;

$tplList = <<<__TEMPLATE__
<tr><td>
{LIST}
</td></tr>
</table>
</body>
</html>
__TEMPLATE__;

$tplItem = <<<__TEMPLATE__
- <a href="{URL}" target="_top">{TITLE} </a>
__TEMPLATE__;
if ( $showdate ) 
    $tplItem .= '({DATE})';
    
if ( $showdesc )
    $tplItem .= '<br />&nbsp;&nbsp;{DESC}<br />';
$tplItem .= '<br />';
$templates = array('Site' => $tplSite, 'List' => $tplList, 'Item' => $tplItem);
$html = getFeed($source, $templates);

echo $html;
?>
