<?
ini_set('include_path', '../../');
require_once "lib/prepend.php";
include_once "mockobjects.php";
require_once "lib/stdlib.php";

include_once 'lib/wiki2docbook/w2dclass.php';
include_once "utils.php";

class DocBookOutputTest extends TestCase
{
	var $Transform;

	function w2dTestCases($name)
	{
		$this->TestCase($name);
	}

	function setUp()
	{
		$aDocInfo  =  array (
				'TopLevelName' => 'article',
				'IncludeXmlDeclaration'=>true,
				'IncludeDtdDeclaration'=>false,
				'FirstSection' => 'section');

		$this->TopLevelElementName = $aDocInfo['TopLevelName'];
	 	$this->IncludeXmlDeclaration = $aDocInfo['IncludeXmlDeclaration'];
	 	$this->IncludeDtdDeclaration = $aDocInfo['IncludeDtdDeclaration'];
	 	$this->DtdPath = '';

	 	$this->Transform = new Wiki2DocBookTransform;
	 	$this->Transform->Params['FirstSectionName'] = $aDocInfo['FirstSection'];
	 	$this->Transform->Params['IndentChar'] = "\t";
		$this->Transform->Params['indent'] = '';
		$this->Transform->Params['Info'] = '';
		$this->Transform->Params['TopLevelTitle'] = '';
		$this->Transform->Params['FirstSectionState'] = 'notstarted';
		$this->Transform->Params['footnotes'] = array();
		
		$this->Transform->registerInline('inline_emphasis');
		$this->Transform->registerInline('inline_quote');
		$this->Transform->registerInline('inline_general_inline');
		$this->Transform->registerInline('inline_doubleBracket');
		$this->Transform->registerInline('inline_footnote');
		$this->Transform->registerInline('inline_bracketlinks');
		$this->Transform->registerInline('inline_rawurl');
		$this->Transform->registerInline('inline_wikiname');

		$this->Transform->register('!', 'block_section');
		$this->Transform->register('_', 'block_section');
		$this->Transform->register('*', 'block_itemizedlist');
		$this->Transform->register('#', 'block_orderedlist');
		$this->Transform->register(';', 'block_variablelist');
		$this->Transform->register(' ', 'block_preformat1');
		$this->Transform->register('{', 'block_preformat2');
		$this->Transform->register('<', 'block_verbatim');
		$this->Transform->register('|', 'block_table');
		$this->Transform->register('[', 'block_bracket');
		$this->Transform->register('(', 'block_general_start');
		$this->Transform->register(')', 'block_general_end');
		$this->Transform->register('%', 'block_ignore');
		$this->Transform->register('@', 'metadata');

	}

	function transform($raw_data)
	{
		 $lines = preg_split('/[ \t\r]*\n/', $raw_data);
		return  $this->Transform->do_transform('', $lines) ;
	}

	function test_para()
	{
		$lines=
"1111";
		$expected = rn2n(
"<para>1111
</para>
");
		$this->assertEquals($expected, $this->transform($lines) );
	}

	function test_programlisting()
	{
		$lines=
"
 hello               world

    <<ee>>
";
		$expected = rn2n(
"<programlisting>
 hello               world

    &lt;&lt;ee&gt;&gt;
</programlisting>
");

		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_preformatted()
	{
		$lines=
"{{{
hello               world
    <<ee>>

}}}
";
		$expected = rn2n(
"<programlisting>
hello               world
    &lt;&lt;ee&gt;&gt;

</programlisting>
");

		$this->assertEquals($expected, $this->transform($lines));
	}



	function test_emphasis()
	{
		$lines="hello '''world'''!";
		$expected = rn2n(
"<para>hello <emphasis>world</emphasis>!
</para>
");
		$this->assertEquals($expected, $this->transform($lines));
	}


	function test_quote()
	{
		$lines="hello ''world''!";
		$expected = rn2n(
"<para>hello <quote>world</quote>!
</para>
");
		$this->assertEquals($expected, $this->transform($lines));
	}

        function test_quote2()
        {
		$lines="''hello'' ''world''!";
		$expected = rn2n(
"<para><quote>hello</quote> <quote>world</quote>!
</para>
");

		$this->assertEquals($expected, $this->transform($lines));
        }

	function test_emphasis_quote()
	{
		$lines = "hello ''world'' '''world'''";
		$expected = rn2n(
"<para>hello <quote>world</quote> <emphasis>world</emphasis>
</para>
");
	}

	function test_itemizedlist_simple()
	{
		$lines =
"* 1
* 2
* 3
";
		$expected = rn2n(
"<itemizedlist>
<listitem><para>1</para>
</listitem>
<listitem><para>2</para>
</listitem>
<listitem><para>3</para>
</listitem>
</itemizedlist>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_itemizedlist_2()
	{
		$lines =
"* 1
** 1.1
*** 1.1.1
";
		$expected = rn2n(
"<itemizedlist>
<listitem><para>1</para>
	<itemizedlist>
	<listitem><para>1.1</para>
		<itemizedlist>
		<listitem><para>1.1.1</para>
		</listitem>
		</itemizedlist>
	</listitem>
	</itemizedlist>
</listitem>
</itemizedlist>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}
	function test_itemizedlist_3()
	{
		$lines =
"* 1
** 1.1
*** 1.1.1
* 2
** 2.1
";
		$expected = rn2n(
"<itemizedlist>
<listitem><para>1</para>
	<itemizedlist>
	<listitem><para>1.1</para>
		<itemizedlist>
		<listitem><para>1.1.1</para>
		</listitem>
		</itemizedlist>
	</listitem>
	</itemizedlist>
</listitem>
<listitem><para>2</para>
	<itemizedlist>
	<listitem><para>2.1</para>
	</listitem>
	</itemizedlist>
</listitem>
</itemizedlist>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_orderedlist()
	{
		$lines =
"# 1
## 1.1
## 1.2
# 2
## 2.1
";
		$expected = rn2n(
"<orderedlist>
<listitem><para>1</para>
	<orderedlist>
	<listitem><para>1.1</para>
	</listitem>
	<listitem><para>1.2</para>
	</listitem>
	</orderedlist>
</listitem>
<listitem><para>2</para>
	<orderedlist>
	<listitem><para>2.1</para>
	</listitem>
	</orderedlist>
</listitem>
</orderedlist>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}


	function test_mixedlist()
	{
		$lines =
"# 1
#* 1.1
#* 1.2
# 2
## 2.1
";
		$expected = rn2n(
"<orderedlist>
<listitem><para>1</para>
	<itemizedlist>
	<listitem><para>1.1</para>
	</listitem>
	<listitem><para>1.2</para>
	</listitem>
	</itemizedlist>
</listitem>
<listitem><para>2</para>
	<orderedlist>
	<listitem><para>2.1</para>
	</listitem>
	</orderedlist>
</listitem>
</orderedlist>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_variablelist()
	{
		$lines =
"; term1 : def1
; term2 : def2
ddd";
		$expected = rn2n(
"<variablelist>
<varlistentry><term>term1 </term>
<listitem><para>def1 </para>
</listitem>
</varlistentry>
<varlistentry><term>term2 </term>
<listitem><para>def2 </para>
</listitem>
</varlistentry>
</variablelist>
<para>ddd
</para>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_ulink()
	{
		$lines =
"[linktext|linktarget] http://kldp.net/ [linktarget]";
		$expected = rn2n(
"<para><ulink url=\"linktarget\">linktext</ulink> <ulink url=\"http://kldp.net/\">http://kldp.net/</ulink> <ulink url=\"linktarget\">linktarget</ulink>
</para>
");
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_rawurl()
	{
		$lines =
"http://a.com/  http://hello.com/html.html";
		$expected = rn2n(
'<para><ulink url="http://a.com/">http://a.com/</ulink>  <ulink url="http://hello.com/html.html">http://hello.com/html.html</ulink>
</para>
');
		$this->assertEquals($expected, $this->transform($lines));
	}
	function test_rawurl2()
	{
		$lines =
"http://www.gpgstudy.com/gpgiki/RecentChanges http://www.win.tue.nl/~kroisos/ http://kldp.net/forum/forum.php?forum_id=17
";
		$expected = rn2n(
'<para><ulink url="http://www.gpgstudy.com/gpgiki/RecentChanges">http://www.gpgstudy.com/gpgiki/RecentChanges</ulink> <ulink url="http://www.win.tue.nl/~kroisos/">http://www.win.tue.nl/~kroisos/</ulink> <ulink url="http://kldp.net/forum/forum.php?forum_id=17">http://kldp.net/forum/forum.php?forum_id=17</ulink>
</para>
');
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_multiple_similiar_urls()
	{
		$lines =
"http://www.gpgstudy.com/ http://www.gpgstudy.com/gpgiki/ http://www.gpgstudy.com/gpgiki/RecentChanges
";
		$expected = rn2n(
'<para><ulink url="http://www.gpgstudy.com/">http://www.gpgstudy.com/</ulink> <ulink url="http://www.gpgstudy.com/gpgiki/">http://www.gpgstudy.com/gpgiki/</ulink> <ulink url="http://www.gpgstudy.com/gpgiki/RecentChanges">http://www.gpgstudy.com/gpgiki/RecentChanges</ulink>
</para>
');
		$this->assertEquals($expected, $this->transform($lines));
	}
	function test_link()
	{
		$lines =" ũ [#ID] Ǵ [ũؽƮ | #ID] Դϴ.";
		$expected = rn2n(
"<para> ũ <link linkend=\"ID\">ID</link> Ǵ <link linkend=\"ID\">ũؽƮ</link> Դϴ.
</para>
");
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_inlinemediaobject()
	{
		$lines = "ζ [image.png] [image.gif]";
		$expected = rn2n(
"<para>ζ <inlinemediaobject><imageobject><imagedata fileref=\"image.png\" /></imageobject></inlinemediaobject> <inlinemediaobject><imageobject><imagedata fileref=\"image.gif\" /></imageobject></inlinemediaobject>
</para>
");
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_simpleinline()
	{
		$lines = "{{keycap F1}}  {{term ȳ}}";
		$expected = rn2n(
"<para><keycap>F1</keycap>  <term>ȳ</term>
</para>
");
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_sections()
	{
		$lines ="!!! 
...
!!! 
...()...
!! ܿ 1
...()...
! Ҵܿ 1
...()...
! Ҵܿ 1
...()...
_!  
_!!  
_!!!   
!!! 
...()...";
	$expected = rn2n(
'
<section><title></title>

<para>...
</para>

</section>

<section><title></title>

<para>...()...
</para>

	<section><title>ܿ 1</title>

	<para>...()...
	</para>

		<section><title>Ҵܿ 1</title>

		<para>...()...
		</para>

		</section>

		<section><title>Ҵܿ 1</title>

		<para>...()...
		</para>

			<section><title> </title>


				<section><title> </title>


					<section><title>  </title>


					</section>

				</section>

			</section>

		</section>

	</section>

</section>

<section><title></title>

<para>...()...
</para>

</section>
');
		$this->assertEquals($expected, $this->transform($lines));
	}
	
	function test_sections_closing()
	{
		$lines ="!!!  1
...
!!  2
...
!  3
";
	$expected = rn2n(
'
<section><title> 1</title>

<para>...
</para>

	<section><title> 2</title>

	<para>...
	</para>

		<section><title> 3</title>


		</section>

	</section>

</section>
');
		$this->assertEquals($expected, $this->transform($lines));
	}	

	function test_sections_started_from_second_level()
	{
		$lines ="!!  1
...
!!  2
...
";
	$expected = rn2n(
'
	<section><title> 1</title>

	<para>...
	</para>

	</section>

	<section><title> 2</title>

	<para>...
	</para>

	</section>
');
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_sections_started_from_third_level()
	{
		$lines ="!  1
...
!  2
...
";
	$expected = rn2n(
'
		<section><title> 1</title>

		<para>...
		</para>

		</section>

		<section><title> 2</title>

		<para>...
		</para>

		</section>
');
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_table()
	{
		$lines = '|! ̺ 
|{ 1 | 2 |3
| 1-1 | 1-2 | 1-3
| 2-1 | 2-2 | 2-3
| 3-1 | 3-2 | 3-3
|} 1 | 2 |3';
		$expected = rn2n(
'<table frame="all"><title>̺ </title>

<tgroup cols="3">
<colspec colname="col1"/>
<colspec colname="col2"/>
<colspec colname="col3"/>
<thead>
	<row><entry>1</entry><entry>2</entry><entry>3</entry></row>
</thead>
<tfoot>
	<row><entry>1</entry><entry>2</entry><entry>3</entry></row>
</tfoot>
<tbody>
	<row><entry>1-1</entry><entry>1-2</entry><entry>1-3</entry></row>
	<row><entry>2-1</entry><entry>2-2</entry><entry>2-3</entry></row>
	<row><entry>3-1</entry><entry>3-2</entry><entry>3-3</entry></row>
</tbody>
</tgroup>
</table>
');
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_informaltable()
	{
		$lines = '| 1-1 | 1-2 | 1-3
| 2-1 | 2-2 | 2-3
| 3-1 | 3-2 | 3-3';
		$expected = rn2n(
'<informaltable frame="all">
<tgroup cols="3">
<colspec colname="col1"/>
<colspec colname="col2"/>
<colspec colname="col3"/>
<tbody>
	<row><entry>1-1</entry><entry>1-2</entry><entry>1-3</entry></row>
	<row><entry>2-1</entry><entry>2-2</entry><entry>2-3</entry></row>
	<row><entry>3-1</entry><entry>3-2</entry><entry>3-3</entry></row>
</tbody>
</tgroup>
</informaltable>
');
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_complex_table()
	{
		$lines = '||v A1-B2 |A3
|B3
|vC1 ||C2-C3
| D2|D3';
		$expected = rn2n(
'<informaltable frame="all">
<tgroup cols="2">
<colspec colname="col1"/>
<colspec colname="col2"/>
<tbody>
	<row><entry namest="col1" nameend="col2" morerows="1">A1-B2</entry><entry>A3</entry></row>
	<row><entry>B3</entry></row>
	<row><entry morerows="1">C1</entry><entry namest="col2" nameend="col3">C2-C3</entry></row>
	<row><entry>D2</entry><entry>D3</entry></row>
</tbody>
</tgroup>
</informaltable>
');
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_general_block()
	{
		$lines = '(((note hello ::note_hello::
 
)))';
		$expected = rn2n(
'<note id="note_hello"><title>hello</title>
<para> 
</para>
</note>
');
		$this->assertEquals($expected, $this->transform($lines));
	}
	
	function test_nested_general_block()
	{
		$lines = '(((note hello ::note_hello::
 
(((example
{{{
printf .....
}}}
)))
)))';
		$expected = rn2n(
'<note id="note_hello"><title>hello</title>
<para> 
</para>
<example>
<programlisting>
printf .....
</programlisting>
</example>
</note>
');
		$this->assertEquals($expected, $this->transform($lines));
	}	

	function test_footnote()
	{
		$lines = 'GPG ø[1]...

[1] Game Programming Gems
';
		$expected = rn2n(
'<para>GPG ø<footnote>
<para>
Game Programming Gems
</para>
</footnote>
...
</para>

');
		$this->assertEquals($expected, $this->transform($lines));
	}	

	function test_multiple_footnote()
	{
		$lines = 'GPG ø[1]...

[1] Game Programming Gems

AI Wis ø[2]...

[2] AI Game Programmming Wisdom
';
		$expected = rn2n(
'<para>GPG ø<footnote>
<para>
Game Programming Gems
</para>
</footnote>
...
</para>

<para>AI Wis ø<footnote>
<para>
AI Game Programmming Wisdom
</para>
</footnote>
...
</para>

');
		$this->assertEquals($expected, $this->transform($lines));
	}	

}

?>
