<?php
/**
 * Data Ŭ   
 *
 * @package php.db
 */

import("php.lang.PObject");
import("php.lang.Tag");
import("php.util.ArrayUtil");

/**
 * Data ü  Լ 
 * 
 * <code>echo data_(null, array(....), array(....));</code>
 * 
 * @param $connector IConnector 
 * @param $fields array ʵ帮Ʈ
 * @param $rows array Ÿ迭
 * @return Data  Data ü
 */
function data_($connector = null, $fields = array(), $rows = array()) { 
	$data = new Data($connector);

	if ($fields)	$data->setFields($fields);
	if ($rows)		$data->setRows($rows);

	return $data;
}


/**
 * ڵ  Data ִ Ŭ
 *
 * @package php.db
 * @see DBClient, IConnector
 */
class Data extends PObject implements ArrayAccess {

	/**
	 * Connector ()
	 *
	 * @var		IConnector
	 */
	protected $connector;

	/**
	 * Data Ŭ  Ŭ ̸
	 *
	 * @var		string		
	 */
	protected $baseClass;

	/**
	 * data  
	 *
	 * @var		integer	
	 */
	protected $listCount;			

	/**
	 * ʵ ̸ 迭
	 *
	 * @var		array
	 */
	protected $fields = array();

	/**
	 * row Ÿ 迭
	 *
	 * @var		array
	 */
	protected $row = array();

	/**
	 * row Ÿ Ű index
	 *
	 * @var		int
	 */
	private $index;

	/**
	 * row Ÿ Ű temp index
	 *
	 * @var		int
	 */
	private $tempIndex;

	/**
	 * 
	 *
	 * @param	IConnector $connector	 
	 */
	public function __construct($connector = null)
	{
		$this->listCount = 0;

		$this->setIndex(-1);
		$this->setConnector($connector);
	}

	/**
	 *  
	 *
	 * @param	IConnector $connector	 
	 */
	public function setConnector($connector) {
		$this->connector = $connector;
	}

	/**
	 *  ϱ 
	 *
	 * @return IConnector   
	 */
	public function getConnector() { 
		return $this->connector;
	}

	/**
	 * Ʈ  0  üũ 
	 *
	 * @return	bool		true :  , false : Ÿ 1 ̻ 
	 */
	public function isEmpty(){
		return ($this->listCount == 0);
	}

	/**
	 *  ڵ ,  false 
	 *
	 * @return	bool		true : Ÿ , false :  Ÿ  
	 */
	public function next()
	{
		if ($this->index >= $this->listCount-1) {
			$this->index = $this->listCount;	
			return false;
		}

		$this->index++;

		return true;
	}

	/**
	 *  ڵ  ,  false  
	 *
	 * @return	bool		true :  Ÿ , false :  Ÿ  
	 */
	public function prev()
	{
		if ($this->index > -1) {
			$this->index--;
			
			return true;
		}

		return false;
	}

	/**
	 * ε ʱȭ.  -1 ʱȭ
	 *
	 */
	public function init()
	{
		$this->setIndex(-1);
	}

	/**
	 *  ε ϱ 
	 *
	 * @return	int   ε ȣ 
	 */
	public function getIndex()
	{
		return $this->index;
	}

	/**
	 *  ε ϱ
	 *
	 * @param	int $index  ε  
	 * @return	Data   Data ü
	 */
	public function setIndex($index)
	{
		$this->index = $index;
		return $this;
	}
	
	/**
	 *  ε ӽ ε ȣ ϰ, ε ʱȭѴ. 
	 *
	 */
	public function saveIndex()
	{
		$this->tempIndex = $this->getIndex();
		$this->init();
	}

	/**
	 * ӽ ε 
	 *
	 */
	public function returnIndex()
	{
		$this->setIndex($this->tempIndex);
	}


	/**
	 * ʵ尪 ´.
	 * 
	 * 
	 * get() ޼ҵ  ޼ҵ
	 * ٸ ü Ӽó    ְ ش. (php5 ̻ ȴ.) 
	 * 
	 * <code>
	 *  $data = new Data(); 
	 *  while($data->next()) { 
	 *     echo $data->name;
	 *  }
	 * </code>
	 *
	 *   ڵ name ̶ public Ӽ   __get ޼ҵ带 ȣѴ. 
	 * __get ޼ҵ ٽ get ޼ҵ带 ȣϰ Ϸ ʵ   ϴ.
	 * 
	 *
	 * @param	string $key	˻ ʵ尪, ҹ   
	 * @return	mixed
	 */
	public function __get($key)
	{
		return $this->get($key);
	}

	/**
	 * ʵ  Ѵ. set ޼ҵ   
	 *
	 * @param	string $key	˻ ʵ尪, ҹ   
	 * @param	mixed $value  
	 */
	public function __set($key, $value)
	{
		$this->set($key, $value);
	}

	/**
	 *  ε شϴ row ʵ   ´. 
	 *
	 * @param	string $key	˻ ʵ̸, ʵ̸ ҹڸ  ʴ´. 
	 * @param	mixed $default ʵ尡 ų ʵ忡   $default  ش. 
	 * @return	mixed
	 */
	public function get($key, $default = '')
	{

		if ($this->index == -1 || $this->index == $this->listCount) {
			return $default;
		}

		$key = $this->filterKey($key);
		$data = $this->row[$this->index][$key];

		if (is_null($data)) return $data;
		if (is_numeric($data)) return $data;

		return ($data) ? $data : $default;
	}

	/**
	 *  ε شϴ row ʵ  Ѵ. 
	 *
	 * @param	string $key		˻ ʵ̸, ʵ̸ ҹڸ  ʴ´. 
	 * @param	mixed $value	 ʵ 
	 */
	public function set($key, $value)
	{
		$key = $this->filterKey($key);
		$this->row[$this->index][$key] = $value;
	}

	/**
	 *  ε شϴ row  ´.
	 *
	 * @return	array
	 */
	public function gets()
	{
		return $this->getRow($this->index);
	}

	/**
	 * ó row  ´.
	 *
	 * @return	array    迭
	 */
	public function getFirst() { 
		return $this->getRow(0);
	}

	/**
	 *  row  ´.
	 *
	 * @return	array   迭
	 */
	public function getLast() { 
		return $this->getRow($this->listCount-1);
	}

	/**
	 * ε ġ ó ̵
	 *
	 */
	public function moveFirst() { 
		$this->setIndex(0);
	}

	/**
	 * ε ġ  ̵
	 *
	 */
	public function moveLast() { 
		$this->setIndex($this->getListCount() - 1);
	}

	/**
	 * ε ġ ó  
	 *
	 * @return 	bool  ó̸ true, ƴϸ false  
	 */
	public function isFirst() { 
		return ($this->getIndex() == 0);
	}

	/**
	 * ε ġ   
	 *
	 * @return 	bool ̸ true, ƴϸ false  
	 */
	public function isLast() { 
		return ($this->getListCount()-1 == $this->getIndex());
	}

	/**
	 * ε ġ ʱȭ   
	 *
	 * @return 	bool ε ʱ true, ƴϸ false  
	 */
	public function isInit() { 
		return ($this->getIndex() == -1);
	}

	/**
	 * ʵ̸ ͸
	 *
	 * @param	string $key	ȯ ʵ ̸ 
	 * @return	string 빮ڷ ȯ Ű̸
	 */
	protected function filterKey($key) {
		return strtolower($key);
	}
	
	/**
	 * ش ε row  
	 *
	 * @param	int $index  ε 
	 * @return	array   迭 
	 */
	public function getRow($index){
		return $this->row[$index];
	}

	/**
	 * data  ִ  row  Ѵ. 
	 *
	 * @return	array  2 ü 迭
	 */
	public function getRows()
	{
		return $this->row;
	}


	/** 
	 * Ư Լ ̿ؼ ȯ  Ѵ 
	 *
	 * <code>
	 *  echo $data->loop(array('func' => 'strtoupper', 'field' => 'ʵ1,ʵ2'), ...);
	 * </code>
	 * 
	 *  
	 * <code>
	 * echo $data->loop(array( 'func' => 'strtoupper', 'param' => array( array('value', ''),  array('field', 'ʵ1,ʵ2'))), ...);
	 * </code>
	 * 
	 * @param array ...   Լ 迭  
	 */
	public function loop() { 
		$arg_list = func_get_args();

		if (count($arg_list) == 0) 
			return $this;

		$this->saveIndex();

		while($this->next()) { 

			foreach ($arg_list as $arg)  { 
				$arg['field'] = array_map('trim', explode(",", $arg['field']));

				foreach ($arg['field'] as $field) { 
					$this->{$field} = call_user_func_array($arg['func'], array($this->{$field}));
				}
			}
		}

		$this->returnIndex();


		return $this;
	}

	/**
	 * data  ִ  row  Ѵ.
	 *
	 * @param	array $rows		 Ÿ  迭
	 */
	public function setRows(array $rows)
	{
		$this->row = $rows;
		$this->listCount = count($this->row);
	}

	/**
	 * row Ÿ ߰ϱ 
	 *
	 * @param	array $arr  Ÿ  迭
	 * @return  Data   Data ü
	 */
	public function add(array $arr)
	{
		$index = $this->listCount;

		// ӽ ε 
		$this->saveIndex();

		//    
		$this->row[$index] = array(); 

		// ε  ϰ 
		$this->setIndex($index);

		// ε ϸ  ..
		$arr = $this->map($arr);
		foreach ($this->fields as $field) {
			$this->set($field, $arr[$field]);
		}

		// Ʈ īƮ  
		$this->listCount++;

		//  ε  
		$this->returnIndex();

		return $this;
	}

	/**
	 * row Ÿ ε
	 *
	 * @param	array $arr	 Ÿ  迭
	 * @param	array $omit	ε    迭 
	 * @return  Data  Data ü
	 */
	public function bind($arr, $omit = array('num')) {
		$arr = $this->map($arr);
		$omit = array_map('strtolower', $omit);

		$keys = array_keys($arr);

		foreach ($this->fields as $field) {
			
			// ʵ  ߿ arr Ű  ε  ʴ´. 
			if (!in_array($field, $keys)) { 
				continue;
			}

			// ε ʵ忡 
			if (in_array($field, $omit)) { 
				continue;
			}

			$this->set($field, $arr[$field]);
		}

		return $this;
	}

	/**
	 * row  Ÿ Ű ϰ ҹڷ ٲش.
	 *
	 * @param	array $arr	 Ÿ  迭
	 * @return	array	
	 */
	protected function map(array $arr) {
		return array_change_key_case($arr, CASE_LOWER);
	}

	/** 
	 * ʵ ̸ ٲٱ 
	 *
	 * <code>$data->convertField(array('A' => '', 'B' => ''))->display();</code>
	 *
	 * @param	array $field_list	ٲ ʵ 
	 * @return  Data  Data ü 
	 */
	public function convertField($field_list = array()) { 
		$keys		= array_values($field_list);
		$temp_keys	= array_keys($field_list);

		$keys		= array_map('strtolower',$keys);		
		$temp_keys	= array_map('strtolower',$temp_keys);

		$this->saveIndex();

		while($this->next()) { 
			foreach ($temp_keys as $key) {
				// ,  Ű   ʵ带 ٲ ʰ Ѿ. 
				if ($field_list[$key] === $key) continue;

				$this->set($field_list[$key], $this->get($key));
				$this->dropData($key);
			}
		}

		// ʵ  ٽ Ѵ. 
		foreach ($this->fields as &$key) { 
			$key = (array_key_exists ( $key, $field_list)) ? $field_list[$key] : $key;
		}

		$this->returnIndex();

		return $this;
	}

	/**
	 * ʵ Ÿ  
	 *
	 *  Ÿ 迭 ܵ˴ϴ. 
	 *
	 * @param	string $key	ٲ ʵ 
	 */
	protected function dropData($key) { 
		unset($this->row[$this->index][$key]);
	}

	/**
	 * ʵ  
	 *
	 * 迭 ܵ˴ϴ. 
	 *
	 * @param	int $key	ٲ ʵ ε 
	 */
	protected function dropField($key) { 
		unset($this->fields[$key]);
	}

	/**
	 * ʵ Ʈ ߰
	 *

	 * @param	string $key	߰ ʵ
	 */
	public function addField($key) {
		$this->fields[] = strtolower($key);
	}

	/**
	 * ʵ Ʈ 
	 *

	 * @param	array $arr	߰ ʵ
	 */
	public function setFields($arr)
	{
		$this->fields = array_map('strtolower',$arr);
	}

	/**
	 * ʵ Ʈ 
	 *

	 * @return	array		ʵ Ʈ 迭 
	 */
	public function getFields()
	{
		return $this->fields;
	}

	/**
	 * ⺻ Ŭ  
	 *

	 * @param	string $class	⺻ Ŭ
	 */
	public function setBaseClass($class)
	{
		$this->baseClass = $class;
	}

	/**
	 * ü row   
	 *

	 * @return	int			row  
	 */
	public function getListCount()
	{
		return $this->listCount;
	}

	/**
	 * ü ʵ   
	 *

	 * @return	int			ʵ  
	 */
	public function getFieldCount()
	{
		return count($this->fields);
	}

	/**
	 * column   迭 ϱ
	 *
	 * <code>
	 * // 1. 1 迭    
	 *  	$data->getColumnList('ʵ');    
	 * 
	 * //   ʵ شǴ column   迭 ݴϴ.
	 *
	 * //   2.  迭  
	 *
	 *			$data->getColumnList('ʵ', 'key ʵ');    
	 *
	 *	//	array('keyʵ' => 'ʵ', ...... )  迭 ݴϴ.
	 * </code>
	 *

	 * @param	string $field	 ʵ
	 * @param	string $key		key ʵ, ⺻ ''
	 * @return	int			ʵ  
	 */
	public function getColumnList($field, $key = '') {
		// Ÿ  
		$this->saveIndex();

		$temp = array();

		while($this->next()) {
			if ($key) { 
				$temp[$this->get($key)] = $this->get($field);
			} else { 
				$temp[] = $this->get($field);
			}
		}

		// ε ֱ 
		$this->returnIndex();

		return $temp;
	}

	/**
	 * ߺ  Ʈ  
	 *

	 * @return array  ߺ  迭
	 */
	public function distinct($field) { 
		$temp_list = $this->getColumnList($field);
		$temp_list = array_unique($temp_list);

		return $temp_list;
	}


	/**
	 *  Dataü  ˻   Data ü  
	 *
	 * <code> $new_data = $data->find('ʵ', ''); </code>
	 *

	 * @param	string $field	˻ ʵ
	 * @param	string|array $value	˻ 
	 * @return	Data 			
	 *
	 */
	public function find($field, $value) { 
		$this->saveIndex();

		if (gettype($value) != 'array') { 
			$value = array($value);
		}

		sort($value);

		$data = new Data($this->getConnector());
		$data->setFields($this->getFields());

		while($this->next()) { 
			if (in_array($this->get($field),$value)) { 
				$data->add($this->gets());
			}
		}

		$this->returnIndex();

		return $data;
	}

	/**
	 *  ϴ ʵθ Ÿ  
	 *
	 *  <code> $new_data = $data->column(array('ʵ1', 'ʵ2','ʵ3')); </code>
	 *

	 * @param	array $field_list	и ʵ Ʈ 
	 * @return	Data 			
	 *
	 */
    public function column() { 

		// ʵ Ʈ   
		$field_list = func_get_args();

		$this->saveIndex();

		$field_list = array_map('strtolower', $field_list);

		$field_list = (count($field_list) == 0) ? $this->getFields() : $field_list;

		$data = new Data($this->getConnector());
		$data->setFields($field_list);

		while($this->next()) { 
			$arr = array();
			foreach ($field_list as $field) { 
				$arr[$field] = $this->get($field);
			}

			$data->add($arr);
		}

		$this->returnIndex();

		return $data;
	}

	/**
	 *   Data 
	 *
	 * <code>$new_data = $data->top(5);</code>
	 *

	 * @param	int $count	  
	 * @return	Data 			
	 *
	 */
	public function top($count) { 
		return $this->page(1, $count);
	}

	/** 
	 * Page ȭ  Data  
	 *
	 * <code>$new_data = $data->page(1, 10);</code>
	 *

	 * @param	int $page		 
	 * @param	int $page_size	   
	 * @return	Data 			
	 *
	 */
	public function page($page = 1, $page_size = 10) { 

		$this->saveIndex();

		$data = new Data($this->getConnector());
		$data->setFields($this->getFields());

		$start = ($page - 1)*$page_size - 1;		//  ׻ -1 

		$this->setIndex($start);
		
		for($i = 0; $this->next() && $i < $page_size; $i++) { 
			$data->add($this->gets());
		}

		$this->returnIndex();

		return $data;

	}

	/** 
	 *   Data ü 迭  
	 *
	 * <code>$new_data_list = $data->split(10);</code>
	 *
	 * @param	int $count		ҵ   , ⺻ 10
	 * @return	array 			
	 *
	 */
	public function split($count = 10) { 
		$page_count = $this->getPageCount($count);
		$arr = array();

		for ($i = 1; $i <= $page_count ; $i++) { 
			$arr[] = $this->page($i, $count);	
		}

		return $arr;
	}

	/**
	 * Ʈ   ؼ   Ѵ.
	 *
	 * <code>$page_count = $data->getPageCount(10);</code>
	 *
	 * @param	int $count		ҵ   , ⺻ 10
	 * @return	int				   			
	 *
	 *
	 */
	public function getPageCount($count = 10) { 
		return ceil($this->getListCount() / $count);
	}

	/**
	 * table ± ü 
	 *
	 * <pre>
	 *   ׽Ʈ Ÿ 
	 * 
	 *   NUM | NAME | AGE
	 *    1  | ZINO | 28 
	 *    2  | SU   | 20 
	 *
	 * ex)  1. $data->toDataTable();			
	 *
	 *		| NUM | NAME | AGE |
	 *		|  1  | ZINO | 28  |
	 *		|  2  | SU   | 20  |
     *
	 *		ü Ÿ ״ table ±׷ 
	 *
	 *      2. $data->toDataTable(array('num'));
	 *
	 *		| NUM | 
	 *		|  1  | 
	 *		|  2  | 
	 *
	 *		num ʵ忡 ؼ table ±׷ 
	 *
	 *      3. $data->toDataTable(array('num'), array('num' => 'Ϸùȣ'));
	 *
	 *		| Ϸùȣ | 
	 *		|  1       | 
	 *		|  2       | 
	 *
	 *		num ʵ忡 ؼ    Ҷ 'num'  'Ϸùȣ'  ٲ ؼ Ѵ. 
	 *  </pre>
	 *

	 * @param	array $field_list	ְ  ʵ Ʈ
	 * @param	array $name_list	ʵ Ʈ ٸ ̸ Ʈ
	 * @return	Tag			table Tag ü 
	 */
	public function toDataTable($field_list = array(), $name_list = array()) 
	{
		$table = T_("table", true);
		$table->setAttribute(
			array('border' => '1')
		);
	
		// µ ʵ  
		$field_list = (count($field_list) == 0) ? $this->fields : $field_list ;
		$hasName = (count($name_list) > 0) ? true : false;

		// ʵ   
		$tr = T_("tr", true);

		foreach ($field_list as $field) {
			$th = T_("th",true);

			if ($hasName) { 
				$th->add(isset($name_list[$field]) ? $name_list[$field] : $field);
			} else {
				$th->add($field);
			}
			$tr->add ($th);
		}

		$table->add($tr);

		// Ÿ  
		$this->saveIndex();

		while($this->next()){  
			$tr =  T_("tr", true);

			foreach ($field_list as $field){
				$f = T_("td", true);
				$f->add($this->get($field));

				$tr->add($f);
			}

			$table->add($tr);
		}

		$this->returnIndex();

		return $table;
	}

	/*
	 * ̺  2°  
	 *
	 * html ±װ ƴ text   
	 *
	 * <pre>
	 * +--------+-------+
	 * | ʵ1  | ʵ2 |
	 * +--------+-------+
	 * |      |     | 
	 * +--------+-------+
	 * </pre>
	 * 
	 *    [pre] ±׸ ٿָ  
	 * <code>echo "<pre>",$data->toScreen(),"</pre>";</code>
	 *
	 * ʵ̸ ٲ㼭   
	 * 
	 * <code>echo $data->toScreen(array('field1','field2'), array('field1' => 'ʵ1','field2' => 'ʵ2'));</code>
	 *
	 * @param array $fields ְ  ʵ Ʈ 
	 * @param array $names ʵ ٸ ̸ Ʈ 
	 * @return string 
	 * 
	 */
	public function toScreen($fields = array(), $names = array())
	{
		$fields = array_map('strtolower', $fields);
		$names = $this->map($names);

		$field_list = (count($fields) == 0) ? $this->fields : $fields ;
		$hasName	= (count($names) > 0) ? true : false;

		//  ϱ 
		$field_length = array();

		foreach ($field_list as $field) { 
			if ($hasName) { 
				$field_length[$field] = strlen($names[$field]);
			} else { 
				$field_length[$field] = strlen($field);
			}
		}

		// Ÿ  ϱ 
		$this->saveIndex();

		while($this->next()){
			foreach ($field_list as $field) {
				$value = $this->get($field);
				$value = trim($value);

				if (strlen($value) > 100) { 
					$value = "[Long Text]";
				}

				$field_length[$field] = max($field_length[$field], strlen($value));
			}
		}

		$this->returnIndex();


		// ʵ  
		$header_length = array();

		foreach ($field_list as $field) { 
			$header_length[$field] = str_repeat("-", $field_length[$field] + 2);
		}

		$separator = '+'.implode('+', $header_length).'+';


		//  Ʈ
		$header_length = array();

		foreach ($field_list as $field) { 
			if ($hasName) { 
				$header_length[$field] = " ".str_pad($names[$field], $field_length[$field])." ";
			} else { 
				$header_length[$field] = " ".str_pad($field, $field_length[$field])." ";
			}
		}

		$header_string = '|'.implode('|', $header_length).'|';


		$output = array($separator, $header_string, $separator);

//		print_p(array($separator, $header_string, $separator));


		$this->saveIndex();
		
		while($this->next()) { 
			$temp = array();
			foreach ($field_list as $field) { 
				$value = is_null($this->get($field)) ? "[NULL]" : $this->get($field);
				$value = trim($value);
				if (strlen($value) > 100) { 
					$value = "[Long Text]";
				}

				$temp[$field] = " ".str_pad($value, $field_length[$field])." ";
			}

			$output[] = '|'.implode('|', $temp).'|';
		}

		$this->returnIndex();

		$output[] = $separator;

		$str = implode(PHP_EOL, $output);

		return $str;
	}


	/*
	 * ̺  1°  
	 *
	 * table ±׷ 
	 *
	 * <pre>
	 *      <table>
	 *          <tr><td>ʵ1</td><td>ʵ2</td></tr>
	 *          <tr><td>1</td><td>2</td></tr>
	 *      </table>
	 * </pre>
	 * 
	 * ʵ̸ ٲ㼭   
	 * 
	 * <code>echo $data->toString(array('field1','field2'), array('field1' => 'ʵ1','field2' => 'ʵ2'));</code>
	 *
	 * @param array $fields ְ  ʵ Ʈ 
	 * @param array $names ʵ ٸ ̸ Ʈ 
	 * @return string 
	 * 
	 */
	public function toString($fields = array(), $names = array())
	{
		$obj = $this->toDataTable($fields, $names);

		return $obj->toString();
	}

	/**
	 * ȭ  , toString ޼ҵ带 ̿ؼ ȭ Ѵ.
	 * 
	 * <code>echo $data->display(array('field1','field2'), array('field1' => 'ʵ1','field2' => 'ʵ2'));</code>
	 *
	 * @param array $fields ְ  ʵ Ʈ 
	 * @param array $names ʵ ٸ ̸ Ʈ 
	 */
	public function display($fields = array(), $names = array())
	{
		echo $this->toString($fields, $names);
	}

	/**
	 * ȭ  , toScreen ޼ҵ带 ̿ؼ ȭ Ѵ.
	 * 
	 * <code>echo $data->screen(array('field1','field2'), array('field1' => 'ʵ1','field2' => 'ʵ2'));</code>
	 *
	 * @param array $fields ְ  ʵ Ʈ 
	 * @param array $names ʵ ٸ ̸ Ʈ 
	 */
	public function screen($fields = array(), $names = array())
	{
		echo $this->toScreen($fields, $names);
	}

	/**
	 * JSON ڵ ȯ 
     * 
	 *  all 
	 * 
	 *  array('field' => .... , 'row' => .... )
	 *
	 *  field 
	 * 
	 *  array( .... )
	 * 
	 *  row 
	 * 
	 *  array( ... )
	 *
	 * @param string $option    all, field, data 
	 * @return string	json ڿ
	 */
	public function toJSON($option = 'all') { 
		
		$option = strtolower($option);

		if ($option == 'all') { 
			return json_encode(array('field' => $this->fields, 'row' => $this->row));
		} else if ($option == 'field') { 
			return json_encode($this->fields);
		} else if ($option == 'row') { 
			return json_encode($this->row);
		}

		return json_encode("");
	}

	/**
	 *   xml ȯش. 
	 * 
	 * <pre>
	 * < data>
	 * 	< record>
	 * 		< field1></ field1>
	 * 		< field2></ field2>
	 * 		< field3_list>
	 * 			< data>....</ data>
	 * 		</ field3_list>
	 * 	 </ record>
	 * 	</ data>
	 * </pre>
	 * 
	 * @return string xml  ڿ 
	 */
	public function toXml()
	{
		$xml = T_("data", true);
		$this->saveIndex();

		while($this->next()){  
			$record =  T_("record", true);

			foreach ($this->fields as $field){

				if (PObject::isObject($this->get($field), 'Data')) { 
					$f = T_(strtolower($field)."_list", true);					
					$str = $this->get($field)->toXml();
				} else { 
					$f = T_(strtolower($field), true);
					$str = $this->get($field);
				}

				$f->add($str);

				$record->add($f);
			}

			$xml->add($record);
		}

		$this->returnIndex();

		return $xml->toString();
	}

	/**
	 *  Data ü ٸ Data ü 
	 *
	 * @param	Data $data	ܺ Data ü 
	 */
	public function setData(Data $data)
	{
		$this->setFields($data->getFields());
		$this->setRows($data->getRows());
		$this->init();
	}

	/** 
	 *   ߰ 
	 *
	 *
	 *  <code>
	 *  $data = new Data();
	 *
	 *	$data->sort(array('field1' => SORT_DESC, 'field2' => SORT_ASC));
     *	$data->sort(array('field1' => 'desc', 'field2' => 'asc'));
	 *
	 *	echo $data;
	 *  </code>
	 *
	 * @param	array $arr	 Ÿ 
	 *
	 **/
	public function sort($arr) {
		$arr = $this->map($arr);

		$this->saveIndex();
		
		$temp = array();
		
		//  Ķ 
		$params = array();

		foreach ($arr as $key => $desc) { 
			// ĵ Ÿ  
			${$key} = $this->getColumnList($key);		

			//  ʵ 
			$params[] = ${$key};						

			//   
			$params[] = (strtolower($desc) == 'desc' or $desc == SORT_DESC ) ? SORT_DESC : SORT_ASC ;	
		}

		$params[] = &$this->row;						// ü Ÿ   


		// Ÿ  Ű ϼ 
		call_user_func_array('array_multisort', $params);

		$this->returnIndex();
	}

	/** 
	 * հ ϱ 
	 * 
	 * @param string $field  հ ϰ ϴ ʵ̸
	 * @return int|float հ
 	 */
    public function sum($field) { 
		$arr = $this->getColumnList($field);

		return array_sum($arr);
	}

	/** 
	 *  ϱ
	 * 
	 * @param string $field   ϰ ϴ ʵ̸
	 * @return int|float 
 	 */
	public function avg($field) { 
		$sum	= $this->sum($field);
		$count	= $this->getListCount();

		return ($count == 0) ?  0 : ($sum/$count);
	}

	/**
	 *  Ÿ  
	 *
	 * <code>
	 * // 1. 
     * echo $data->groupBy('ʵ1,ʵ2', array(array('format' => '{ʵ3}', 'group' => 'sum', 'name' => 'ʵհ')));
	 * // 2. 
     * echo $data->groupBy(array('ʵ1','ʵ2'), array(array('format' => '{ʵ3}', 'group' => 'sum', 'name' => 'ʵհ')));
	 * 
	 * </code>
	 *
	 * 
	 */
	public function groupBy($group_field, $calc_field = array()) { 
		
		// ʵ Ʈ ڿ Դٸ 
		// 迭· ȯ 
		if (gettype($group_field) == 'string') { 
			$group_field = a_()-> r('explode', ",", $group_field)
							   -> r('map','trim')
				               -> to;
		}

		$arr = $this->groupByInit($group_field, $calc_field); 

		// data ü 
		$group_list = array();

		foreach ($calc_field as $calc) { 
			if (gettype($calc) == 'string') { 
				$group_list[$calc] = $calc;
			} else { 
				$group_list[$calc['name']] = $calc['group'];
			}
		}


		//    迭 
		$temp = array();
		
		//  ϱ 
		foreach ($arr as $value_list) { 


			if (!array_key_exists($value_list['%%key_field%%'], $temp)) { 
				$temp[$value_list['%%key_field%%']] = array();
			}

			foreach ($value_list as $key => $value) { 

				//  ʵ 
				if ($key != '%%key_field%%') { 

					$group = $group_list[$key];

					switch($group) { 
					case 'count' : 
						$temp[$value_list['%%key_field%%']][$key]['count'] += 1;
						break;
					case 'sum' : 
						$temp[$value_list['%%key_field%%']][$key]['sum'] += $value;
						break;
					case 'avg' : 
						$temp[$value_list['%%key_field%%']][$key]['count'] += 1;
						$temp[$value_list['%%key_field%%']][$key]['sum'] += $value;
						$temp[$value_list['%%key_field%%']][$key]['avg'] = 1;
						break;
					default : 
						$temp[$value_list['%%key_field%%']][$key]['count'] += 1;
						break;
					}
				}
			}
		}

		//  ϱ 
		foreach ($temp as &$data) { 
			foreach ($data as &$group_by_data) { 
				//   Ȯؼ 
				if ($group_by_data['avg'] == 1) { 
					//  ϰ 
					$group_by_data['avg'] = ($group_by_data['count'] == 0) ? 0 : $group_by_data['sum']/$group_by_data['count'];

					//   ִ Ÿ ޸ 󿡼  
					unset($group_by_data['count']);
					unset($group_by_data['sum']);
				}
			}
		}

		$field_list = array_merge($group_field, array_keys($group_list));


		// ׷ Ÿ  
		$group_data = data_(null, $field_list);

		foreach ($temp as $key_field => $value_data ) { 

			$key_list = $this->getGroupByDivideField($key_field);

			// group by ʵ  
			$temp_field = array_combine($group_field, $key_list);

			//  Ÿ ʵ  
			foreach ($value_data as $field => $value) { 
				$temp_field[$field] = array_sum($value);
			}

			// Ÿ ֱ 
			$group_data->add($temp_field);
		}


		return $group_data;
	}

	// ⺻ Ÿ 
	protected function groupByInit($group_field, $calc_field) { 
		$arr = array();
		
		$this->saveIndex();

		while($this->next()) { 
			$key_field = $this->getGroupByKeyField($group_field);

			$temp = array('%%key_field%%' => $key_field);
			
			$temp = array_merge($temp, $this->getGroupByField($calc_field));

			$arr[] = $temp;
		}

		$this->returnIndex();

		return $arr;
	}

	//  ʵ ʱȭϱ 
	protected function initGroupByField($f) { 
		// 1. as  ̸ иؼ ̶ Ī Ѵ. 
		if (gettype($f) == 'string') { 
			return array('name' => $f, 'format' => "{".$f."}", 'group' => 'count');
		}

		return $f;

	}

	/**
	 *    
	 * 
	 * <code>echo $data->run('{a}-{b}-{c}');</code>
	 *  
	 * @param $format string    
	 * @return mixed  ϰ 
	 */
	public function run($format) { 

		//   
		$format = $this->template($format);

		//   
		$code = "\$temp = $format;";

		// ڵ м
		eval($code);

		return $temp;
	}

	// ʵ尪  
	protected function getGroupByField($calc_field) { 
		$temp = array();

		foreach ($calc_field as $f) { 

		    $f = $this->initGroupByField($f);

			$temp[$f['name']] = $this->run($f['format']);
		}

		return $temp;
	}

	/**
	 * ø ȯ 
	 *
	 * ־ ø ؼ ʵ尪 a,b,c   ȯؼ ڿ Ѱش. 
	 * 
	 * {ʵ̸}  ʵ 
	 * 
	 * <code>echo $data->template('{a}-{b}-{c}');</code>
	 * 
	 * @param $format string ȯ ڿ 
	 */
	public function template($format = '') { 
		$pattern = "/\{([^\}]+)\}/";

		preg_match_all($pattern, $format, $all);

		foreach ($all[0] as $key => $value) { 
			$format = str_replace($value, $this->get($all[1][$key]), $format);
		}

		return $format;		
	}

	// ׷찪 Ī
	protected function getGroupByKeyField($group_field) { 
		$temp = array();

		foreach ($group_field as $f) { 
			$temp[] = $this->get($f);
		}

		return implode("%%", $temp);
	}

	protected function getGroupByDivideField($key_field) { 
		return explode("%%", $key_field);		
	}

	/**
	 * Ӽ 翩 Ȯ 
	 * 
	 * @return boolean
	 */
	function offsetExists($name) {
		return in_array(strtolower($name), $this->fields);
	}


	/**
	 * Ӽ   
	 * 
	 * @return mixed
	 */
	function offsetGet($name) {
		return $this->get($name);
	}

	/**
	 * Ӽ  
	 */
	function offsetSet($name, $value) {
		$this->set($name, $value);
	}

	/**
	 *  Ӽ   
	 */
	function offsetUnset($name) {
		$this->dropData($name);
	}

}
?>