<?php
/**
 * Mssql
 *
 * @package php.db
 */
import("php.db.DBClient");
import("php.db.MssqlConfig");

/**
 * DBClient ƿƼ ԼԴϴ.
 * 
 * <code>$db = mssql_('test_db', true); </code>
 *
 * @see DB_()
 * @param string $db ȯ漳   ̸
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Mssql DBClient  ü
 */
function MSSQL_($db, $isConnect = false) { 
	return DB_('mssql', $db, $isConnect);
}

/**
 * Mssql  Ŭ 
 * 
 * @package php.db
 */
class Mssql extends DBClient {

	private $bindList = array();

	private $defineList = array();

	/** 
	 * 
	 */
	public function __construct($host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '') {
		$program		= strtoupper(__CLASS__);
		parent::__construct($program, $host, $port, $id, $pass, $db, $schema, $version);
	}


	/**
	 * database  
	 * 
	 * @return resource  resource
	 */
	protected function _connect() { 
		return mssql_connect(sprintf("%s,%s", $this->host, $this->port), $this->id, $this->pass);
	}

	/** 
	 * DB ϱ 
	 */
	protected function _selectDb() { 
		mssql_select_db($this->db, $this->con);
	}

	/**
	 *  row  
	 *
	 * @return int 
	 */
	public function affectedRows() { 
		return mssql_rows_affected($this->con);
	}

	/**
	 *  ġ ڵ   
	 *
	 * @param resource $result select  resource
	 * @return bool
	 * @see Mssql::query()
	 */
	public function batch($result) { 
		return mssql_fetch_batch($result);
	}

	/**
	 * Ʈ  
	 * 
	 * @return bool 
	 * @see Mssql::commit(), Mssql::rollback();
	 */
	public function begin() { 
		return $this->query("BEGIN TRAN");
	}

	/** 
	 * bind ޼ҵ 
	 *
	 * @param resource $stmt init()  resource
	 * @param string $name ε  ̸
	 * @param mixed $value ε  
	 * @param string $type ε Ÿ,  php MSSQL   ȯǼ ȴ.   
	 * @param bool $isOutput  ,  : true, Է : false 
	 * @param bool $isNull  뿩, ̸ true, ƴϸ false 
	 * @param int $maxLength ε  , -1 Ѿ 
	 * @return bool 
	 */
	public function bind($stmt, $name, &$value, $type, $isOutput = false, $isNull = false , $maxLength = -1){
		return mssql_bind($stmt, $name, $value, $this->getTypeName($type), $isOutput, $isNull, $maxLength);
	}

	/**
	 *  ݱ 
	 */
	public function close() {
		mssql_close($this->con);
	}

	/** 
	 * commit 
	 *
	 * mssql ڵ commit ϱ  ڵcommit    ݵ begin() ޼ҵ带  ؾѴ.
	 * 
	 * @return bool
	 * @see Mssql::begin(), Mssql::rollback();
	 */
	public function commit() { 
		return $this->query("COMMIT TRAN");
	}

	/**
	 * ¡ DBData ü  
	 *
	 * @param resource $result select  resource 
	 * @param int $page   
	 * @param int $pagesize   Ʈ  
	 * @param string $baseClass ʱȭ DBData  Ŭ ̸ 
	 * @return DBData
	 */
	public function createPageData($result, $page, $pagesize, $baseClass = "DBData") {
		// ⺻ Data Ŭ ϰ 
		// Data Ŭ  ٸ Data Ŭ ϸ ȴ. 
		$data = new $baseClass();
		$data->setBaseClass($baseClass);
		$data->setDatabase($this);

		//ʵ Ʈ 
		$data->setFields($this->getFieldList($result));
		
		if (!$result) 
			return $data;

		while($d = $this->fetch($result)) 
			$data->add($d);

		return $data;
	}

	/**
	 *  ޼ 
	 * 
	 * @return string  ޼ 
	 */
	public function error() {
		return "";
	}

	/**
	 * ν  
	 *
	 * ν  resource select    Ǿٸ select  resource ȯѴ. 
	 * 
	 * @return resource|bool ν  ҽ
	 */
	public function execute() {
		$this->exec = mssql_execute($this->stmt);
		return $this->exec;
	}


	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $result select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($result) {
		return mssql_fetch_assoc($result);
	}

	/** 
	 * ޸  
	 * 
	 * @return bool
	 */
	public function free($result) { 
		return mssql_free_result($result);
	}

	/**
	 * ν ޸  
	 * 
	 * @param resource $result mssql_init() Լ   resource 
	 * @return bool  
	 * @see Mssql::init()
	 */
	public function freeStatement($result) {
		// 
		return mssql_free_statement($result);
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($result) {
		return mssql_num_fields($result);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($result, $i) {
		return mssql_field_name($result, $i);
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($result, $i) {
		return mssql_field_type($result, $i);
	}

	/**
	 * select  ؼ ¡ DBData Ѵ. 
	 *
	 * @param string $query select 
	 * @param int $page    
	 * @param int $count  Ʈ  
	 * @param string $baseClass  DBData   Ŭ , ⺻ DBData  
	 * @return DBData
	 */
	public function getPageData($query, $page = 1, $count = 10, $baseClass = 'DBData') {
		$total = $page * $count;

		$query = "select top {$total} * from ($query) TEMP_SELECT ";

		// ..
		$this->query($query, $total);

		// ġ ̵ 
		$this->seek(($page-1)*$count);

		$data = $this->createData($this->getResult(), $baseClass);

		return $data;

	}

	/**
	 * ڿ  Ÿ̸ PHP ȯ 
	 *
	 * @return int PHP
	 */
	private function getTypeName($type)
	{
		$type = strtolower($type);

		switch ($type) {
			case 'smalldatetime' :
			case 'datetime' :
			case 'varchar': 
			case 'nvarchar':
			case 'binary':
			case 'image':
			case 'varbinary':
			case 'sql_variant':
				return SQLVARCHAR;
			case 'tinyint': 
			case 'smallint':
			case 'int': 
			case 'bigint':
			case 'timestamp':
				return SQLINT4;
			case 'text' : 
			case 'ntext':
				return SQLTEXT;
			case 'bit' : 
				return SQLBIT;
			case 'float' :
			case 'decimal' :
			case 'money' : 
			case 'real':
				return SQLFLT8;
			default: 
				return $type;
		}
	}

	/** 
	 * ν ʱȭ 
	 * 
	 * @param string $sp_name ν̸ 
	 * @return resource ʱȭ resource
	 */
	public function init($sp_name) {
		$this->stmt = mssql_init($sp_name);
		return $this->stmt;
	}

	/**
	 *   2 ̻ select  Ǿ ִٸ  result set ȯѴ. 
	 *
	 * <code>
	 * $resource = $mssql->query("select 1; select 2");
	 * 
	 * $second_result = $mssql->nextResult($result);
	 *
	 * echo $mssql->fetch($second_result);   // array([2] => 2)
	 *
	 * </code>
	 * 
	 * @param resource $result select  resource
	 * @return resource ι° select  resource
	 */
	public function nextResult($result) {
		return mssql_next_result($result);
	}


	/** 
	 * Ϲ   
	 * 
	 * @param string $sql  query 
	 * @param int $batch_size Ǿ ѹ ޸𸮿  ڵ  
	 * @return resource  resource
	 */
	public function query($sql, $batch_size = -1) {

		$args = array($sql, $this->con);

		if (intval($batch_size) > 0) { 
			$args[] = $batch_size;
		} 


		$this->result = call_user_func_array('mssql_query', $args);

		return $this->result;
	}	

	/**
	 * ũ   Ҷ ̸ ־ ϴ ޼ҵ
	 *
	 * @return bool 
	 */
	public function remote()
	{
		return $this->query("SET ANSI_NULLS ON ; SET ANSI_WARNINGS ON;");
	}

	/**
	 *  row ʵ  ٷ  
	 *
	 * @param resource $result select  resource
	 * @param int $row rowȣ,  0  
	 * @param int|string $field ʵġ( 0) Ǵ ʵ̸, Ǵ table.ʵ̸ 
	 * @return mixed
	 */
	public function result($result, $row, $field) 
	{
		return mssql_result($result, $row, $field);
	}

	/** 
	 * rollback
	 *
	 * @return bool 
	 */
	public function rollback() { 
		return $this->query("ROLLBACK TRAN");
	}

	/**
	 * Ŀ ̵ 
	 * 
	 * @param int $count ̵ų ġ,  0 
	 * @return bool
	 */
	public function seek($count) { 
		return mssql_data_seek($this->getResult(), $count);
	}

	/**
	 * ν 
	 * 
	 * @return bool ̸ true, ̸ false
	 */
	public function spExecute() {
	
		// ν ʱȭ 
		$this->__sp_statement = mssql_init($this->__sp_name);


		// ε 
		foreach (array_keys($this->__sp_bind_list) as $key) { 

			// ̸  
			if ($this->__sp_bind_list[$key]['output'] == 'return') { 
				$param_name	=  'RETVAL';
			} else { 
				$param_name	=  '@'.$this->__sp_bind_list[$key]['name'];
			}

			//   
			$isOutput	= ($this->__sp_bind_list[$key]['output'] == 'in') ? false : true;
			
			// ε 
			mssql_bind(
					$this->__sp_statement, 
					$param_name, 
					$this->__sp_bind_list[$key]['value'], 
					$this->getTypeName($this->__sp_bind_list[$key]['type']), 
					$isOutput, 
					false, 
					$this->__sp_bind_list[$key]['length']
			);

		}
	
		// ν  
		return mssql_execute($this->__sp_statement);
	
	}

}

?>