<?php
/**
 * Upload Ŭ 
 *
 * @package php.net
 *
 */
import("php.lang.PObject");

/**
 *  ε  Ŭ 
 *
 * form  enctype  multipart/form-data ·  Ÿ  մϴ. 
 *
 * @package php.net
 *
 */
class Upload extends PObject {
	private $field;
	private $isArray;
	private $count;

	/**
	 * 
	 * 
	 * <code>
	 * $upload = new Upload('userfile');		// Ѱ  ε   
	 * $upload = new Upload('userfile', true);  //   ε   
	 * </code>
	 *
	 * @param	string $field form  input type="file" ± ̸ 
 	 * @param	bool $isArray false : 迭 ƴ, true :  迭  
	 *
	 */
	public function __construct($field, $isArray = false) {
		$this->field = $field;
		$this->isArray = $isArray;

		if ($isArray) {
			$this->count = count($_FILES[$field]['tmp_name']);
		} else {
			$this->count = 1;
		}
	}

	/**
	 *  ε   
	 * 
	 * @return	int		 ε  
	 */
	public function getCount()
	{
		return $this->count;
	}

	/**
	 * ε   Ӽ  ,   ߰ ˴ϴ. 
	 * 
	 * <pre>
	 * php ϴ  Ӽ 
	 *
	 *   name		  ̸ 
	 *   type		MIME Type
	 *   size		 ũ 
	 *   tmp_name	ӽ ̸ 
	 *	 error		ڵ   ,  ڵ  php ޴  	
	 *
	 *
	 * Ȯ Ӽ 
	 *
	 *   filename	Ȯڸ   ̸ 
	 *   ext		 Ȯ 
	 *
	 * </pre>
	 *
	 * <code>
	 * $upload = new Upload('userfile');
	 * echo $upload->get('name');
	 * </code>
	 *
	 * 
	 * @param	string $type  Ӽ (name, type, size, tmp_name, error, filename, ext)
	 * @param	int $i	  
	 * @return	string	 ŸԺ Ӽ  
	 *
	 */
	public function get($type, $i = 0) {
		//  ̸ ϱ 
		if ($type == 'filename') {
			$var = explode(".", $this->get('name'));

			array_pop($var);
			return implode(".", $var);
		} 
		// Ȯ ϱ 
		else if ($type == 'ext') {
			$arr = explode(".", $this->get('name', $i));
			
			return $arr[count($arr)-1];

		} 
		// ⺻ Ӽ  
		else {
			if ($this->isArray) {
				return $_FILES[$this->field][$type][$i];
			} else {
				return $_FILES[$this->field][$type];
			}
		}
	}

	/**
	 * ε  ű 
	 * 
	 * @return	int		 ε  
	 */
	public function move($file = '', $i = 0) {
		if ($file == '') { 
			$file = $this->get('name');
		}

		return move_uploaded_file($this->get('tmp_name', $i), $file);
	}


	/**
	 * ε   ű 
	 * 
	 *
	 * @param	array @arrFile	ű ϸ Ʈ 
	 * @return	int		 ε  , 0 ̸ ü ε , 1 ̸̻  ε  ȣ
	 *
	 */
	public function moveAll($arrFile = array()) {
		for ($i = 0; $i < $this->getCount(); $i++) {

			if ($this->get('tmp_name', $i) === "") {
				continue;
			}

			if (!$this->move($arrFile[$i], $i)) {
				return $i+1;
			}
		}

		return 0;
	}

	/**
	 * ε  ش η  ű 
	 * 
	 * <code>$upload->moveAllUrl('/home/cyberuls/');</code>
	 *
	 * @param	string @url	ű ּ 
	 * @return	int		 ε , 0 ̸ ü ε , 1 ̸̻  ε  ȣ
	 *
	 */
	public function moveAllUrl($url) {
		for ($i = 0; $i < $this->getCount(); $i++) {

			if ($this->get('tmp_name', $i) === "") {
				continue;
			}

			$str = implode("/", array_push(explode("/", $url), $this->get('name',$i)));

			if (!$this->move($str, $i)) {
				return $i+1;
			}
		}

		return 0;
	}

	/**
	 *  ε Ȳ ֱ 
	 */
	public function display() {
		echo "<pre>";
		print_r($_FILES);
		echo "<pre>";
	}
} 

?>