<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: common.php,v 1.4.2.1 2004/04/01 01:06:59 lseeker Exp $
 */

define('__VERSION__', 'Spiral-2');

/* FOR RELEASE */
error_reporting(E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR);
set_magic_quotes_runtime(0);

/* {{{ MessageBox class */
class MessageBox {
    var $title   = 'MESSAGE';
    var $message = '';
    var $type    = NULL;
    var $list_page;
    var $list_no;

    function registerTitle($title) {
        $this->title =& $title;
    }

    function registerMessage($message) {
        $this->message =& $message;
    }

    function setTypeList($page, $no) {
        $this->type      = 2;
        $this->list_page = (int) $page;
        $this->list_no   = (int) $no;
    }

    function setTypeBack() {
        $this->type = 1;
    }

    function printOut() {
        echo <<<MESSAGEBOX
<div id="hbMBox">
 <div class="bgTitle fgSpc2 hbTitle">{$this->title}</div>
 <div class="bgImage hbMessage">
  <p class="center">{$this->message}</p>
MESSAGEBOX;

        switch($this->type) {
            case 1:
                echo '<p class="center">[<a href="javascript: history.back(1);">돌아가기</a>]</p>';
                break;
            case 2:
                echo "<p class=\"center\"><span class=\"fgSpc1\">잠시 후에 <a href=\"list.php?page={$this->list_page}#{$this->list_no}\"><b class=\"fgSpc1\">게시물 목록</b></a>으로 이동합니다.</span></p>\n<script type=\"text/javascript\">\n<!--\nwindow.setTimeout('movetolist({$this->list_page}, {$this->list_no})', 1500);\n//-->\n</script>";
                break;
        }

        echo '</div></div>';
    }
}
/* }}} */

// 관리자 설정을 db에서 불러옵니다.
$dbinfo = file('db/dbconn.php') or die('오류 발생: 게시판이 설치되어 있지 않습니다.<br />설치 메뉴얼을 참조하신 후, 설치해 주시기 바랍니다.');

$db['dbms'] = trim($dbinfo[1]);
require "lib/db.{$db['dbms']}.php";
$DB = new DB(trim($dbinfo[2]), trim($dbinfo[3]), trim($dbinfo[4]), trim($dbinfo[5]));
 
$AdminData = new DBResult($DB->query('SELECT * FROM hboard_db_admin'));
$admin_data =& $AdminData->fetch();
$AdminData->free();

define('__SKIN__', $admin_data['skin']);

/* FIXME Spiral-2 잡질....
 * deleted_num = app * 100;
 * width_max = width_max << 10; */
$admin_data['deleted_num'] = (int) ($admin_data['app'] / 100);
$admin_data['app'] = $admin_data['app'] - $admin_data['deleted_num'] * 100;

$admin_data['allow_filetype'] = $admin_data['width_max'];
$admin_data['width_max'] = $admin_data['width_max'] >> 10;

$admin['login'] = isset($_COOKIE['hboard_admin_login']) && !strcmp($admin_data['passwd'], get_magic_quotes_gpc() ? stripslashes($_COOKIE['hboard_admin_login']) : $_COOKIE['hboard_admin_login']) ? 1 : 0; 

/* FIXME 임시로 여기에 위치 ;;; */
function &remove_space($str) {
    return trim(str_replace('　', ' ', $str));
}

function error_exit($message, $layout = FALSE) {
    $ErrorBox = new MessageBox;
    $ErrorBox->setTypeBack();
    $ErrorBox->registerTitle('ERROR');
    $ErrorBox->registerMessage($message);

    if ($layout) {
        $Layout = new Layout($GLOBALS['admin_data']);
        $Layout->hideText();
        $Layout->hideInclude();

        $Layout->printHeader();
        $ErrorBox->printOut();
        $Layout->printFooter();
    } else {
        $ErrorBox->printOut();
    }

    exit;
}

?>
