<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 Yun-young Lee
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: writeform.php,v 1.16 2004/03/17 10:56:25 lseeker Exp $
 */

class WriteForm {
    var $action;
    var $onsubmit = 'true';
    var $title    = '';

    var $name     = '';
    var $email    = '';
    var $homepage = '';
    var $subject  = '';
    var $content  = '';
    var $icon     = '';

    var $i_password = '<input type="password" name="passwd" size="9" maxlength="8" />';
    var $i_hidden   = '';
    var $backbutton = '';
    var $filedesc   = '';

    var $t_title = TRUE;
    var $t_file  = TRUE;
    var $preview;

    function WriteForm($type) {
        if (!method_exists($this, $type)) trigger_error("Invalid WriteFrom type {$type}", E_USER_ERROR);
        $this->preview = 'skin/' . __SKIN__ . '/preview.jpg';
        $this->$type();
    }

    function readCookie() {
        $this->name     = isset($_COOKIE['etchibbs_name']) ? $_COOKIE['etchibbs_name'] : '';
        $this->email    = isset($_COOKIE['etchibbs_mail']) ? $_COOKIE['etchibbs_mail'] : '';
        $this->homepage = isset($_COOKIE['etchibbs_home']) ? $_COOKIE['etchibbs_home'] : '';
        $this->icon     = isset($_COOKIE['etchibbs_icon']) ? $_COOKIE['etchibbs_icon'] : '';

        if (get_magic_quotes_gpc()) {
            $this->name     = stripslashes($this->name);
            $this->email    = stripslashes($this->email);
            $this->homepage = stripslashes($this->homepage);
            $this->icon     = stripslashes($this->icon);
        }

        $this->name     = htmlspecialchars($this->name);
        $this->email    = htmlspecialchars($this->email);
        $this->homepage = strcmp($this->homepage, '') ? htmlspecialchars($this->homepage) : 'http://';

        if (strcmp($this->icon, '')) {
            $this->icon = str_replace('/', '_', $this->icon);
            $this->icon = str_replace('\\', '_', $this->icon);
        } else {
            $this->icon = 'none.jpg';
        }
    }

    function readArticle(&$article) {
        $this->name     = htmlspecialchars($article->name);
        $this->email    = htmlspecialchars($article->email);
        $this->homepage = strcmp($article->homepage, '') ? htmlspecialchars($article->homepage) : 'http://';
        $this->subject = htmlspecialchars($article->subject);
        $this->content = htmlspecialchars($article->content);
    }

    function registerTitle($title) {
        $this->title =& $title;
    }

    function registerFileDesc($desc) {
        $this->filedesc =& $desc;
    }

    function registerHiddenInput($input) {
        $this->i_hidden =& $input;
    }

    function registerPreviewImage($image) {
        $this->preview =& $image;
    }

    function hidePasswordInput() {
        $this->i_password = '(관리자 로그인 상태)';
    }

    function show() {
        $WFormSkin = __SKIN__;
        $WFormPreviewImage = $this->preview;

        echo <<<WFormFirst
<form method="post" action="{$this->action}" enctype="multipart/form-data" onsubmit="return {$this->onsubmit};">
<div id="hbWForm">
 <table align="center" cellpadding="1" cellspacing="0">
  <tr>
   <td colspan="2" class="bgTitle fgSpc2 hbTitle">{$this->i_hidden}
    <img src="skin/{$WFormSkin}/write.gif" alt="Write" class="middle" />
    {$this->title}
   </td>
  </tr>
  <tr>
   <td class="bgImage hbTBody">
    <table cellpadding="0" cellspacing="1">
     <tr>
      <td>Name</td>
      <td><input type="text" name="name" size="20" maxlength="30" value="{$this->name}" /></td>
     </tr>
     <tr>
      <td>Mail</td>
      <td><input type="text" name="email" size="32" maxlength="100" value="{$this->email}" /></td>
     </tr>
     <tr>
      <td>URL(*)</td>
      <td><input type="text" name="homepage" size="32" maxlength="255" value="{$this->homepage}" /></td>
     </tr>
WFormFirst;

        if ($this->t_file) echo "<tr><td>File</td><td><input type=\"file\" name=\"picture\" size=\"16\" maxlength=\"255\" onchange=\"preview_upload(this.value);\" onblur=\"preview_upload(this.value);\" /><span class=\"fontXSmall\"> {$this->filedesc}</span></td></tr>";

        echo "<tr><td>Password</td><td>{$this->i_password}</td></tr>";

        if ($this->t_title) echo "<tr><td>Title</td><td><input type=\"text\" name=\"title\" size=\"32\" maxlength=\"255\" value=\"{$this->subject}\" /></td></tr>";
        else PrintIconSelect($this->icon);

        echo <<<WFormLast
     <tr>
      <td colspan="2"><textarea name="ne" rows="7" cols="45">{$this->content}</textarea></td>
     </tr>
     <tr>
      <td colspan="2" align="center">
       <input name="submit_btn" type="submit" value="Submit" accesskey="s" />
       <input type="reset" value="Reset" /> {$this->backbutton}
      </td>
     </tr>
    </table>
   </td>
   <td valign="middle" class="bgImage hbTBody">
    <div id="d_pic">
     <img id="pic" src="{$this->preview}" alt="Preview" />
    </div>
   </td>
  </tr>
 </table>
</div>
</form>
WFormLast;
    }

    function article() {
        $this->action   = 'post_article.php';
        $this->onsubmit = 'checkform_article(this, true)';
        $this->title    = '새 게시물 작성하기..';

        $this->backbutton = '';
    }

    function modify() {
        $this->action   = 'post_modify.php';
        $this->onsubmit = 'checkform_article(this, false)';
        $this->title    = '게시물 수정하기..';

        $this->backbutton  = '[<a href="javascript: history.back(1);">돌아가기</a>]';
        $this->i_password .= ' <span class="fontXSmall">(글 작성시 입력하였던 비밀번호)</span>';
        $this->filedesc = '(파일 수정시에만)';
    }

    function comment() {
        $this->action   = 'post_comment.php';
        $this->onsubmit = 'checkform_comment(this)';
        $this->title    = '의견 남기기';

        $this->backbutton  = '[<a href="javascript: history.back(1);">돌아가기</a>]';

        $this->t_file  = FALSE;
        $this->t_title = FALSE;
    }
}

function PrintIconSelect($cookie_icon) {
    echo <<<ICONT
<tr>
 <td>Icon</td>
 <td>
  <select name="icon" onchange="preview_icon(this.value, document.getElementById('pic'));">
   <option value="none.jpg">(아이콘 없음)</option>
   <option value="none.jpg">--------------------</option>
ICONT;

    $handle = opendir('db/ico/');
    while ( ($file = readdir($handle)) !== FALSE) {
        if ($file != '.' && $file !='..' && $file != 'index.html') {
            if (strcmp($cookie_icon, 'none.jpg')) $selected = strcmp($file, $cookie_icon) ? '' : ' selected="selected"';
            $file = htmlspecialchars($file);
            echo "<option value=\"{$file}\"{$selected}>{$file}</option>\n";
        }
    }
    closedir($handle);

    echo '</select></td></tr>';
}

?>
