<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: post_article.php,v 1.44 2004/03/23 16:41:36 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/layout.php';
include 'lib/article.php';

/* 오류 처리 */
/* PHP 업로드 에러코드 확인 */
if ($_FILES['picture']['error']) error_exit("<b>PHP 업로드 처리중에 오류가 발생했습니다.</b><br />PHP Upload Error Code: {$_FILES['picture']['error']}", TRUE);

/* 그림 크기가 관리자가 제한한 크기보다 클 경우 (0은 무제한 의미이므로 생략..) */
if ($admin_data['fileup_max'] && $_FILES['picture']['size'] > $admin_data['fileup_max']) error_exit(sprintf("<b>파일이 너무 큽니다!</b><br />파일 크기는 최대 %dKB로 제한됩니다.", $admin_data['fileup_max'] / 1024), TRUE);

$Article = new Article;
$Article->readPost();

if (!strcmp($Article->name, '') || empty($_FILES['picture']['tmp_name']) || !strcmp($_POST['passwd'], '') || $_POST['ne'] == '') error_exit('<b>데이터가 모두 전송되지 않았습니다.</b><br />필요한 폼에 데이터를 모두 채워주세요.', TRUE);

$Article->writeCookie();

/* 그림파일 처리 */
$Image = new Image($Article->image);
if ($admin_data['backdrum']{0} == 't') $Image->checkMD5();
if ($admin_data['allow_filetype'] & FILETYPE_CHECK) $Image->checkFileType($admin_data['allow_filetype']);

/* DB 업데이트 */
ignore_user_abort(TRUE); /* 비정상 종료 방지 */
$DB->begin(FALSE);
$Article->writeDB();
$Image->upload($Article->no);
$DB->commit(FALSE);
$DB->close();

/* 출력 */
$Layout = new Layout($admin_data);
$Layout->hideInclude();

$MessageBox = new MessageBox;
$MessageBox->setTypeList(1, $Article->no);
$MessageBox->registerTitle('안내');
$MessageBox->registerMessage('게시물 저장을 완료했습니다.');

$Layout->printHeader();
$MessageBox->printOut();
$Layout->printFooter();

?>
