<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: rename_icon.php,v 1.16 2004/03/16 02:25:55 lseeker Exp $
 */

require 'lib/common.php';
$DB->close();

header('Content-Type: text/html; charset=UTF-8');

if (!$admin['login']) error_exit('관리자 쿠키를 찾을 수 없습니다.', FALSE);

$file = get_magic_quotes_gpc() ? stripslashes($_GET['file']) : $_GET['file'];

if (!file_exists('db/ico/' . $file)) error_exit('이름을 변경하려는 아이콘을 찾을 수 없습니다.', FALSE);

$file_html = htmlspecialchars($file);
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
 <title>EtchiBBS 아이콘 관리자</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="internal.css" rel="stylesheet" type="text/css">
</head>

<body onload="document.getElementById('rename_to').focus();">
<div id="config">
 <div id="confhead">
  <h1>아이콘 이름 바꾸기</h1>
  <div id="confclose"><a href="javascript: window.close();">창 닫기</a></div>
 </div>
 <p class="center">
 <img src="<?php echo 'db/ico/' . rawurlencode($file); ?>" alt="<?php echo $file_html; ?>" /><br />
 <em><?php echo $file_html; ?></em> 아이콘의 <span class="blue">이름을 변경</span>합니다.
 </p>
 <form method="post" action="rename_icon_ok.php">
  <p class="center">
  <input type="hidden" name="file" value="<?php echo $file_html; ?>" />
  <label for="rename_to">Rename to:</label>
  <input type="text" id="rename_to" name="rename_to" value="<?php echo $file_html; ?>" maxlength="100" />
  <input type="submit" value="바꾸기"> 
  <input type="button" value="취소" onclick="history.back(1);">
  </p>
 </form>
 <p class="center">정보: 아이콘의 이름을 변경하면, 이전에 해당 아이콘을<br />
 사용한 의견글의 아이콘 또한 이름이 함께 변경됩니다.</p>
</div>
</body>
</html>
