/**
 * 
 */
package kr.ac.kaist.swrc.jhannanum.module.filter;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;

import kr.ac.kaist.swrc.jhannanum.module.Module;

/**
 * @author Sangwon Park (hudoni@world.kaist.ac.kr), CILab, SWRC, Kaist
 *
 */
public class WebInputFilter implements Module {
	final static private String MODULE_NAME = "WebInputFilter";
	final static private int REPEAT_CHAR_ALLOW = 10;
	
	private BufferedReader in = null;
	private PrintWriter out = null;
	
	public String getName() {
		return MODULE_NAME;
	}
	
	public void initialize(Reader in, Writer out, String configFile) throws Exception {
		if (in != null) {
			this.in = new BufferedReader(in);
		} else {
			this.in = null;
		}

		if (out != null) {
			this.out = new PrintWriter(out);
		} else {
			this.out = null;
		}
	}
	
	public void run() throws Exception {
		String line = null;
		String word = null;
		
		while ((line = in.readLine()) != null) {
			StringTokenizer st = new StringTokenizer(line, " \t");
			
			while (st.hasMoreTokens()) {
				word = st.nextToken();
				
				/* ݺǴ Ưȣ Ǵ 1  ó */
				if (word.length() > REPEAT_CHAR_ALLOW) {
					char[] wordArray = word.toCharArray();
					int repeatCnt = 0;
					char checkChar = wordArray[0];
					
					if (checkChar != '"' && checkChar != '\'') {
						out.print(checkChar);
					}

					for (int i = 1; i < wordArray.length; i++) {
						if (checkChar == wordArray[i]) {
							if (repeatCnt == REPEAT_CHAR_ALLOW - 1) {
								continue;
							}
							repeatCnt++;
						} else {
							checkChar = wordArray[i];
							repeatCnt = 0;
						}
						if (checkChar != '"' && checkChar != '\'') {
							out.print(checkChar);
						}
					}
				} else {
					out.print(word);
				}
				out.print(' ');
			}
			out.print('\n');
			out.flush();
		}
	}
	
	public void setReader(Reader in) {
		if (in != null) {
			this.in = new BufferedReader(in);
		} else {
			this.in = null;
		}
	}

	public void setWriter(Writer out) {
		if (out != null) {
			this.out = new PrintWriter(out);
		} else {
			this.out = null;
		}
	}
	
	public void shutdown() {
		
	}
}
