// PadDraw2.cpp : Implementation of CPadDraw2

#include "stdafx.h"
#include "PadRecog2.h"
#include "PadDraw2.h"
//#include "define.h"
#include "engin\PreProcess.h"
/////////////////////////////////////////////////////////////////////////////
// CPadDraw2

CPadDraw2::CPadDraw2()
{
	//----   ʱȭ --------------------------------------------------------------------
	m_bWindowOnly = TRUE;								//  ڵ   ֵ Ѵ.

	m_nActMode = 2;										// Է  (1 : SignPad, 2 : Mouse)
	m_bExistSignpad = FALSE;							// е尡 ִ 
	m_bOpenedSignpad = FALSE;							// е 尡 ִ 
	m_bStartSign = FALSE;								// е Է ޱ ߴ 
	m_nStrokeCnt = 0;									// ȹ īƮ 
	m_bLBDown = FALSE;									// 콺  ư ȴ  

	m_nRecogWaitTime = 700;							// ȹ    ν ð(MilliSecond)
	m_nPadLineWith = 0;

	m_bDisplayCharAtCtrl = FALSE;

	memset(m_result, NULL, sizeof(WORD) * 11);			// ν 

	memset(m_szFont, 0x00, sizeof(m_szFont));
	strcpy(m_szFont, "");							// Ʈ Ʈ

	// ӽ θ Ѵ.
	char szTempPath[MAX_PATH];
	size_t nLen;
	nLen = GetTempPath(sizeof(szTempPath), szTempPath);
	strcat(szTempPath, _T("\\signpad_temp.bmp"));
	m_strTempPath = szTempPath;

	m_nDrawScope = DIRECT_SIGNPAD + DIRECT_CONTROL;
	m_nShowScope = DIRECT_SIGNPAD + DIRECT_CONTROL;

	m_bNeedCleanMore = TRUE;

	m_nCountStroke = 0;	
	m_nAllPts = 0;
}

CPadDraw2::~CPadDraw2()
{
	//ӽ 
	if((_access(m_strTempPath.begin(), 0)) != -1 )
	{
		DeleteFile(m_strTempPath.begin());
	}
}

HRESULT CPadDraw2::OnDraw(ATL_DRAWINFO& di)
{

	RECT& rc = *(RECT*)di.prcBounds;

	StretchBlt(di.hdcDraw, rc.left, rc.top, rc.right, rc.bottom, 
			m_hMemDC, 1,1, m_nPadWidth, m_nPadHeight, SRCCOPY);

	return S_OK;
}

LRESULT CPadDraw2::OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{

	m_nPadWidth = 128;
	m_nPadHeight = 64;

	//---- ޸ DC, Ʈ ʱȭ -----------------------------------------------------------
	RECT rct;
	int nClientWidth = 0;
	int nClientHeight = 0;

	GetClientRect(&rct);
	nClientWidth = rct.right - rct.left + 1;
	nClientHeight = rct.bottom - rct.top + 1;

	HDC hDC = GetDC();
	m_hMemDC = CreateCompatibleDC(hDC);
	m_hBM = CreateCompatibleBitmap(hDC, nClientWidth, nClientHeight);
	
	HPEN hPen = CreatePen(PS_SOLID, 1, RGB(0xFF, 0xFF, 0xFF));
	HBRUSH hBrush = CreateSolidBrush(RGB(0xFF, 0xFF, 0xFF));
	HPEN hOldPen = (HPEN)SelectObject(m_hMemDC, hPen);
	HBRUSH hOldBrush = (HBRUSH)SelectObject(m_hMemDC, hBrush);
	SetBkMode(hDC, TRANSPARENT);
	SelectObject(m_hMemDC, m_hBM);	
																
// 	Rectangle(m_hMemDC, -1, -1, nClientWidth+2, nClientWidth+2);	//   ä.
	Rectangle(m_hMemDC, -1, -1, nClientWidth+2, nClientHeight+2);	//   height , dglee, 090421

	SelectObject(m_hMemDC, hOldPen); 
	SelectObject(m_hMemDC, hOldBrush);
	DeleteObject(hPen);
	DeleteObject(hBrush);

	ReleaseDC(hDC);
	
	//---- νĿ ʱȭ --------------------------------------------------------------------
	m_writingRect.left = 0;
	m_writingRect.top  = 0;
	m_writingRect.right  = m_nPadWidth;
	m_writingRect.bottom = m_nPadHeight;

	m_nStrokeCnt =0;									// ȹ ʱȭ 

	OpenSignpad();
	if(m_bOpenedSignpad == TRUE)
	{
		//StartSignpad();
	}

	//Fire_Ready();
	return 0;
}

LRESULT CPadDraw2::OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{

	HDC hDC = GetDC();

	DeleteObject(m_hBM);
	ReleaseDC(m_hMemDC);

	if(m_bStartSign == TRUE)
	{
		FinishSignpad();
	}
	CloseSignPad();
	return 0;
}


/////////////////////////////////////////////////////////////////////////////////////////////////////
// е Ʈ Open
/////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL CPadDraw2::OpenSignpad()
{
	int nRet;
	char data;
	m_nComPort = AutoComPort();
	
	if(m_nComPort == 0){	
        ProgramStopCommand();
		
		//𵨸 
		ModelNameCommand();
		m_strModelName = "";
		for(int i=0; i<8; i++)
		{
			data = NameDataRead();
			m_strModelName += data;
		}

		//ȸ   е  MSP-1000̴.
        if(m_strModelName == "MSP-1000") m_nSignpadModel = MSP_1000;
		else if(m_strModelName == "MSP-2000") m_nSignpadModel = MSP_2000;
		else 
		{
			MessageBox("MIP е ̿ ġ  ʽϴ!", "", MB_OK);
		}

		// б
	    m_strVersion = "";
		for(i=0; i<7; i++)
		{
            data = NameDataRead();
			m_strVersion += data;
		}

		// 
        data = NameDataRead();		
		if(data == 0x30) 
		{
			m_nLanguage = 1;
		}
		else 
		{
			m_nLanguage = 2;
		}
		m_bExistSignpad = TRUE;
		m_bOpenedSignpad = TRUE;

		// ޴ ġ  =>  0̸  
		nRet = SetMenuLocation(MENU_POS_RIGHT);
	}
	else
	{
		m_bExistSignpad = FALSE;
		m_bOpenedSignpad = FALSE;
	}

	Sleep(100);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
// е Ʈ Close
/////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL CPadDraw2::CloseSignPad()
{
	if(m_bOpenedSignpad == TRUE)
	{
		CloseComPort();
		m_bOpenedSignpad = FALSE;
	}
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
// е Ʈ Ÿ Է 
/////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL CPadDraw2::StartSignpad()
{
	if(m_bStartSign == FALSE)
	{
		ClearStrokeBuffer();
		RealtimeSignCommand();
		SetRealtimeSign();

		SetTimer(TIMERID_PAD_POLLING, 10);
		m_bStartSign = TRUE;
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
// е Ÿ Է 
/////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL CPadDraw2::FinishSignpad()
{
	LONG num ;

	if(m_bStartSign == TRUE)
	{
		ClearStrokeBuffer();
	
		KillTimer(TIMERID_PAD_POLLING);
		num = ProgramStopCommand();
		if(num != 0)
		{
			ProgramStopCommand();
		}
		m_bStartSign = FALSE;

		m_vecStroke.clear();
		m_FilteredStroke.clear();

		Fire_InputEnded();
		m_bNeedCleanMore = TRUE;
	}

	return TRUE;
}


LRESULT CPadDraw2::OnLButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	//SetCapture(m_hWnd);
	// ٽ Է ۵ǾǷ Ÿ̸Ӹ δ.
	KillTimer(TIMERID_RECOG_START);		

	SetCapture();
	
	short x, y;

	x = LOWORD(lParam);
	y = HIWORD(lParam);

	m_tPrevPos.x = x;
	m_tPrevPos.y = y;

	m_vecStroke.push_back(m_tPrevPos);

	m_bLBDown = TRUE;

	Fire_RecogDone();
	return 0;
}


LRESULT CPadDraw2::OnLButtonUP(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	m_bLBDown = FALSE;

	m_vecStroke.push_back(m_tPrevPos);
	ReleaseCapture();

	// ȹ νĿ  ͸
	StrokeFilter_2(m_vecStroke, m_FilteredStroke);

	// ȹ νĿ 
	for(int i=0; i<m_FilteredStroke.size();i++)
	{
		AddPoint_DUMMY(m_FilteredStroke[i]);
	}

	m_vecStroke.clear();
	m_FilteredStroke.clear();
	m_nStrokeCnt ++; 

	// νĿԷµ Ʈ ȹ ׷ȭ
	EndStroke_DUMMY();
	SetTimer(TIMERID_RECOG_START, 2000);	// Է Ḧ üũϱ  Ÿ̸ 
	
	return 0;
}


LRESULT CPadDraw2::OnMouseMove(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{

	if(m_bLBDown == TRUE)
	{
		short x, y;
		POINT tPos;
		POINT pt[2];
		HDC hDC = GetDC();

		x = LOWORD(lParam);
		y = HIWORD(lParam);

		tPos.x = x;
		tPos.y = y;

		pt[0] = m_tPrevPos;
		pt[1] = tPos;

		Polyline(hDC, pt, 2);
		
		m_tPrevPos = tPos;
		m_vecStroke.push_back(tPos);

		ReleaseDC(hDC);
	}
	

	return 0;
}


LRESULT CPadDraw2::OnTimer(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	LONG nTimerID;
	BOOL bInputEnd = FALSE;

	nTimerID = wParam;
	
	switch(nTimerID)
	{
	case TIMERID_PAD_POLLING:		//------- е   --------------
		ReadSignPadData(bInputEnd);
		if(bInputEnd == TRUE)
		{
			DoRecog_DUMMY();				// ν
			FinishSignpad();		// Է 	
		}
		break;

	case TIMERID_RECOG_START:		// ------- ν  ------------------------
		DoRecog_DUMMY();					// ν
		DoRecogByBNNetwork();
		FinishSignpad();			// Է 
		m_nCountStroke = 0;
		break;
	}

	return 0;
}

BOOL CPadDraw2::DoRecog_DUMMY()
{
	//OutputDebugString(_T("DoRecog_DUMMY !!!!!!!!!!!!!!\n\n"));
	KillTimer(TIMERID_RECOG_START);	
	ClearView();
	Fire_RecogComplete();

	return TRUE;
}
/*
_____________________________________________________________
  
Լ̸:   DoRecogByBNNetwork - еκ Էµ Ʈ   ν 

 :  
		
ȯ:				
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/
void CPadDraw2::DoRecogByBNNetwork()
{
	int nStrkNum = m_nCountStroke;			//еκ о ü ȹ
	OVR_POINT* pPts = (OVR_POINT*)malloc(m_nAllPts*sizeof(OVR_POINT));
	
	STROKE* pStrk = (STROKE*)malloc(nStrkNum*sizeof(STROKE));
	int n=0;
	for(int i=0;i<nStrkNum;i++)
	{
		pStrk[i].stPtNo = m_nOrder[i].cx;
		pStrk[i].edPtNo = m_nOrder[i].cy;		
		for(int j=0;j<m_nPts[i];j++)
		{
			pPts[n].nX = m_AllVecStroke[i][j].x;
			pPts[n].nY = m_AllVecStroke[i][j].y;
			n++;
		}
	}	
	CPreProcess preprocess;
	int NorPtNum,nNewPtNum,SamNum;
	STROKE* pNorStrk = (STROKE*)malloc(nStrkNum*sizeof(STROKE));
	
	//------- Էڷ ȭ ----------
	OVR_POINT* pNorPt = preprocess.LinearNormalizeOnlyHorW(pPts,m_nAllPts,pStrk,pNorStrk,nStrkNum,NorPtNum);
	//----------------------------------

	//-------  Ʈ    ǥȭ -------
	int SamNo[100];
	OVR_POINT* pNewPt = preprocess.GetAllPtArryAndResample(pNorPt,NorPtNum,pNorStrk,nStrkNum,SamNo,SamNum,nNewPtNum);
	//---------------------------------------

	free(pPts);
	free(pStrk);
	free(pNorPt);
	free(pNorStrk);

	//---------- ν -----------
	float Dis;
	int r = theRecog.RecogDigit(pNewPt,SamNo,SamNum,Dis);
	char szRec[MAXSAMNUM]; memset(szRec,0,MAXSAMNUM);
	sprintf(szRec,"Recog Result = %d",r);	
	MessageBox(szRec);
	//---------------------------

}
///////////////////////////////////////////////////////////////////////////////////////////////////
// е ǽð Է ͸ д´.
///////////////////////////////////////////////////////////////////////////////////////////////////
BOOL CPadDraw2::ReadSignPadData(BOOL bInputEnd)
{
	LONG num, i, j, ii, jj;
	WORD data;
	long x, y, xx, yy;

	HDC hDC;
	hDC = GetDC();

	bInputEnd = TRUE;

	num = RealtimeSizeRead();
	if(num > 0)
	{
		RECT Rect = {0,};
		
	    static long Width ;//= Rect.right - (Rect.left + 535);
	    static long Height ;//= Rect.bottom - (Rect.top + 377);

		Width = 1;
		Height = 1;

		for(i=0; i<num; i++)
		{
			data = RealtimeDataRead();

			// [̺Ʈ]  -----------------------------------------------------------
		    if(data == 0xfcfc)			
			{   
				//TRACE(_T(" ̺Ʈ ߻\n"));
			}
			// [̺Ʈ] UP -------------------------------------------------------------
			else if(data == 0xfdfd)	 
			{
				//TRACE(_T("̺Ʈ ߻\n"));
				
				m_nOrder[m_nCountStroke].cx = m_nAllPts;
				int nPtNum = m_vecStroke.size();
				for(j=0;j<nPtNum;j++)
				{					
					m_AllVecStroke[m_nCountStroke][j].x = m_vecStroke[j].x;
					m_AllVecStroke[m_nCountStroke][j].y = m_vecStroke[j].y;
					m_nAllPts++;
				}
				m_nOrder[m_nCountStroke].cy = m_nAllPts-1;
				
				m_nPts[m_nCountStroke] = nPtNum;
				m_nCountStroke++;
				StrokeFilter_2(m_vecStroke, m_FilteredStroke);
				
				// ȹ νĿ 
				for(j=0; j<m_FilteredStroke.size();j++)
				{
					AddPoint_DUMMY(m_FilteredStroke[j]);
				}
				
				// νĿԷµ Ʈ ȹ ׷ȭ
				EndStroke_DUMMY();

				m_vecStroke.clear();
				m_FilteredStroke.clear();

				m_nStrokeCnt ++; 
				SetTimer(TIMERID_RECOG_START, m_nRecogWaitTime);
			}

			// [̺Ʈ] β ٲٱ ̺Ʈ  ------------------------------------------
			else if((data & 0xff00) == 0xfb00)
			{
                if((data & 0x00ff) == 0x31) m_nPadLineWith = 1;		//ι° β 
				else if((data & 0x00ff) == 0x32) m_nPadLineWith = 2;	//° β
					 else m_nPadLineWith = 0;
			}

			// [̺Ʈ]  ġ   ------------------------------------------------
			else
			{
				//x = (data >> 8);
			    //y = (data & 0x00ff);  

				KillTimer(TIMERID_RECOG_START);
				POINT pt; 

				xx = Width + (data >> 8) ;
			    yy = Height + (data & 0x00ff) ;  

				x = Width + (data >> 8) * PAD_LINE_WIDTH ;
			    y = Height + (data & 0x00ff) * PAD_LINE_WIDTH ;  

				//SetPixel(hDC, xx, yy, RGB(0, 0, 0));
				//KillTimer(ID_TIMER_ENDCHECK);
				
				pt.x = (LONG) xx;
				pt.y = (LONG) yy;

				m_vecStroke.push_back(pt);
				

				if( (m_nDrawScope & 0x02) > 0 )
				for(ii=-1 ; ii <=1 ; ii++)
					for(jj=-1 ; jj<=1 ; jj++)
					{
						SetPixel(hDC, x+ii, y+jj, PAD_OUT_COLOR);
						SetPixel(m_hMemDC, xx+ii, yy+jj, PAD_OUT_COLOR);
					}
			}
		}
	}

	else
	{
		// üũѴ.
		num = RealtimeEndRead();
		if(num == 0)
		{
			bInputEnd = TRUE;			
		}
	}

	ReleaseDC(hDC);

	return TRUE;
}


VOID CPadDraw2::ClearView()
{
	//HDC hDC = GetDC();
	Rectangle(m_hMemDC, -1, -1, m_nPadWidth+2, m_nPadHeight+2);	//  ä.
	InvalidateRect( NULL, TRUE);

	//ReleaseDC(hDC);
}


STDMETHODIMP CPadDraw2::get_RecogResult(BSTR *pVal)
{
	// TODO: Add your implementation code here

	OLECHAR result[2];

	result[0] = m_result[0];
	result[1] = NULL;

	*pVal = SysAllocString(result);

	return S_OK;
}

STDMETHODIMP CPadDraw2::ShowHanja(BSTR strVal)
{
	// TODO: Add your implementation code here

	USES_CONVERSION;
    LPTSTR lpChar = W2A(strVal);

	//----- ü  ---------------------------------------------------------
	HDC hDC = GetDC();
	HDC hMemDC = CreateCompatibleDC(hDC);
	HBITMAP hBM = CreateCompatibleBitmap(hMemDC, m_nPadWidth, m_nPadHeight);
	HBITMAP hOldBM = (HBITMAP)SelectObject(hMemDC,hBM);

	//----- ھ ---------------------------------------------------------
	HPEN hPen = CreatePen(PS_SOLID, 1, RGB(0xFF, 0xFF, 0xFF));
	HBRUSH hBrush = CreateSolidBrush(RGB(0xFF, 0xFF, 0xFF));
	HFONT hFont = CreateFont(55,0,0,0,100,0,0,0,HANGEUL_CHARSET,3,2,1,0, m_szFont);

	HPEN hOldPen = (HPEN)SelectObject(hMemDC, hPen);
	HBRUSH hOldBrush = (HBRUSH)SelectObject(hMemDC, hBrush);
	HFONT hOldFont = (HFONT)SelectObject(hMemDC, hFont);
	HFONT hOldFont2 = (HFONT)SelectObject(m_hMemDC, hFont);

	Rectangle(m_hMemDC, -1, -1, m_nPadWidth+2, m_nPadHeight+2);	//  ä.
	Rectangle(hMemDC, -1, -1, m_nPadWidth+2, m_nPadHeight+2);	//  ä.

	// SignPad  
	if( (m_nShowScope & DIRECT_SIGNPAD) > 0 )
	{
		TextOutW(hMemDC, 5 , 2, strVal, 2);
	}

	// Control  
	if( (m_nShowScope & DIRECT_CONTROL) > 0 )
	{
		TextOutW(m_hMemDC, 5 , 2, strVal, 2);
	}

	
	MakeBitmapFile(hMemDC, hBM, 1);
	
	//----- ü  --------------------------------------------------------
	SelectObject(hMemDC, hOldBM);
	DeleteObject(hBM);
	DeleteObject(hBrush);
	DeleteObject(hPen);
	DeleteObject(hFont);
	DeleteDC(hMemDC);
	ReleaseDC(hDC);

	InvalidateRect(NULL);	// ȭ 

	//----- е忡 ̹ ǥ -------------------------------------------
	int nRet;
	if(m_bOpenedSignpad == TRUE) 
	{

		if(m_bStartSign == FALSE)
		{
			if(m_nSignpadModel == MSP_1000) 
				nRet = SetBitMap( 2, m_strTempPath.begin() );
			else if(m_nSignpadModel == MSP_2000)
				nRet = SetBitMap( 1, m_strTempPath.begin() );
		}
		else
		{
			MessageBox("Է ̹ ۵Ǿϴ.", "", MB_OK || MB_ICONEXCLAMATION);
		}
	}

	return S_OK;
}

VOID CPadDraw2::MakeBitmapFile(HDC hDCBitmap, HBITMAP hbmBitmap, WORD BitCount)
{

	BITMAP                  bm;
	BITMAPINFOHEADER        bi;
	LPBITMAPINFOHEADER      lpbi;
	DWORD                   dwLen;
	HANDLE                  handle;
	HANDLE                  hDIB;
	HPALETTE                hPal=NULL;
	if (hPal==NULL)
	hPal = (HPALETTE) GetStockObject(DEFAULT_PALETTE);

	GetObject(hbmBitmap, sizeof(BITMAP), &bm);
	
	bi.biSize               = sizeof(BITMAPINFOHEADER);
	bi.biWidth              = bm.bmWidth;
	bi.biHeight             = bm.bmHeight;
	bi.biPlanes             = 1;
	bi.biBitCount           = BitCount;		
	bi.biCompression        = BI_RGB;
	bi.biSizeImage          = bm.bmWidth * bm.bmHeight * 3;
	bi.biXPelsPerMeter      = 0;
	bi.biYPelsPerMeter      = 0;
	bi.biClrUsed            = 0;
	bi.biClrImportant       = 0;

	int nColors = (1 << bi.biBitCount);
	if( nColors > 256 ) 
		nColors = 0;
	dwLen  = bi.biSize + nColors * sizeof(RGBQUAD);
	
	hPal = SelectPalette(hDCBitmap,hPal,FALSE);
	RealizePalette(hDCBitmap);

	hDIB = GlobalAlloc(GMEM_FIXED,dwLen);
	
	lpbi = (LPBITMAPINFOHEADER)hDIB;

	*lpbi = bi;
	
	GetDIBits(hDCBitmap, 
		  hbmBitmap, 
          0, 
          (DWORD)bi.biHeight,
          (LPBYTE)NULL, 
          (LPBITMAPINFO)lpbi, 
          (DWORD)DIB_RGB_COLORS);
	
	bi = *lpbi;

	if (bi.biSizeImage == 0)
	{
		bi.biSizeImage = ((((bi.biWidth * bi.biBitCount) + 31) & ~31) / 8) 
										* bi.biHeight;
	}
	
	dwLen += bi.biSizeImage;
	if (handle = GlobalReAlloc(hDIB, dwLen, GMEM_MOVEABLE))
		hDIB = handle;

	lpbi = (LPBITMAPINFOHEADER)hDIB;

	GetDIBits(hDCBitmap, 
             hbmBitmap,
             0,                    
             (DWORD)bi.biHeight,      
             (LPBYTE)lpbi        
             + (bi.biSize + nColors * sizeof(RGBQUAD)),
             (LPBITMAPINFO)lpbi,   
             (DWORD)DIB_RGB_COLORS);

	BITMAPFILEHEADER      hdr;
	
	hdr.bfType        = ((WORD) ('M' << 8) | 'B');        
	hdr.bfSize        = GlobalSize (hDIB) + sizeof(hdr);   
	hdr.bfReserved1   = 0;                                 
	hdr.bfReserved2   = 0;                                 

	hdr.bfOffBits=(DWORD)(sizeof(hdr)+lpbi->biSize + nColors * sizeof(RGBQUAD));

	char * pBmpBuf; 
	DWORD FileSize; 

	FileSize = sizeof(hdr)+GlobalSize(hDIB);
	pBmpBuf = new char[FileSize];
	
	memcpy(pBmpBuf, &hdr, sizeof(hdr));
	memcpy(pBmpBuf + sizeof(hdr), lpbi, GlobalSize(hDIB));

	FILE* file = NULL;
	file = fopen(m_strTempPath.begin(), "wb");
	fwrite(pBmpBuf, FileSize, 1, file);
	fclose(file);

	delete[] pBmpBuf;
	if(hDIB) 
	{		
		GlobalFree(hDIB);
	}
	SelectPalette(hDCBitmap,hPal,FALSE);
}

STDMETHODIMP CPadDraw2::Restart()
{
	// TODO: Add your implementation code here
	// е 

	FinishSignpad();
	StartSignpad();
	return S_OK;
}

STDMETHODIMP CPadDraw2::StartInput()
{
	// TODO: Add your implementation code here
	// е Է  
	StartSignpad();
	return S_OK;
}


STDMETHODIMP CPadDraw2::FinishInput()
{
	// TODO: Add your implementation code here
	FinishSignpad();
	return S_OK;
}

STDMETHODIMP CPadDraw2::ClearLCDDisplay()
{
	// TODO: Add your implementation code here

	MessageBox("Don't use this interface", "by hong", MB_OK);
	Rectangle(m_hMemDC, -1, -1, m_nPadWidth+2, m_nPadHeight+2);	//  ä.
	InvalidateRect(NULL);

	ClearStrokeBuffer();
	LcdAllCleanCommand();
	return S_OK;
}

STDMETHODIMP CPadDraw2::get_RecogWaitTime(long *pVal)
{
	// TODO: Add your implementation code here
	*pVal = m_nRecogWaitTime;
	return S_OK;
}

STDMETHODIMP CPadDraw2::put_RecogWaitTime(long newVal)
{
	// TODO: Add your implementation code here
	m_nRecogWaitTime = newVal;
	return S_OK;
}

// ۸ Ŭ Ų.
VOID CPadDraw2::ClearStrokeBuffer()
{
	m_vecStroke.clear();
	m_FilteredStroke.clear();

	m_nCountStroke = 0;
	m_nAllPts = 0;
}

STDMETHODIMP CPadDraw2::StartInputWithClear()
{
	USES_CONVERSION;
	BSTR strVal = SysAllocString(A2W(" "));

	FinishSignpad();
	ShowHanja(strVal);
	StartInput();
	return S_OK;

}


STDMETHODIMP CPadDraw2::StartInputWithHanja(BSTR strVal)
{
	// TODO: Add your implementation code here

	FinishSignpad();
	ShowHanja(strVal);
	StartInput();
	return S_OK;
}

STDMETHODIMP CPadDraw2::SetFont(BSTR strVal)
{
	// TODO: Add your implementation code here
	USES_CONVERSION;
    LPTSTR lpChar = W2A(strVal);

	memset(m_szFont, 0x00, sizeof(m_szFont));
	strcpy(m_szFont, lpChar);

	return S_OK;
}

STDMETHODIMP CPadDraw2::get_ShowScope(long *pVal)
{
	// TODO: Add your implementation code here
	*pVal = m_nShowScope;
	return S_OK;
}

STDMETHODIMP CPadDraw2::put_ShowScope(long newVal)
{
	// TODO: Add your implementation code here
	m_nShowScope = newVal;
	return S_OK;
}

STDMETHODIMP CPadDraw2::get_DrawScope(long *pVal)
{
	// TODO: Add your implementation code here
	*pVal = m_nDrawScope;
	return S_OK;
}

STDMETHODIMP CPadDraw2::put_DrawScope(long newVal)
{
	// TODO: Add your implementation code here
	m_nDrawScope = newVal;
	return S_OK;
}

STDMETHODIMP CPadDraw2::testmodule()
{
	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CPadDraw2::get_Name(long *pVal)
{
	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CPadDraw2::put_Name(long newVal)
{
	// TODO: Add your implementation code here

	return S_OK;
}
