// RecogCore.cpp: implementation of the CRecogCore class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "RecogCore.h"
#include <math.h>
#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRecogCore::CRecogCore()
{
	BNNum = 0;
	m_BN = NULL;
}

CRecogCore::~CRecogCore()
{
	EndDIC();
}
/*
_____________________________________________________________
  
Լ̸:		CreateParentLink   - BN  θ Ѵ.

 :		"Bayesian networkmodeling of strokes and their relationships
				for on-line handwriting recognition"  
				Pattern Recognition 37 (2004) 253 . 264
		
ȯ:			TRUE: :False: 		
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/

BOOL CRecogCore::CreateParentLink(DigitBN *pBN)
{
	int StrkNum = pBN->StrokeNum;
	if(StrkNum<1)return FALSE;
	int i,j,st;
	StrokeModel* pStroke,*pPreStroke;
	PointModel* pPoint;
	for(i=0;i<pBN->StrokeNum;i++){
		pStroke = &(pBN->pStroke[i]);

		if(i==0 ){
			st=0;
			for(j=st;j<WSRS;j++){
				pStroke->pPoint[j] = (PointModel*)malloc(sizeof(PointModel));
			}
		}
		else{
			st=1;
			for(j=st;j<WSRS;j++){
				pStroke->pPoint[j] = (PointModel*)malloc(sizeof(PointModel));
			}
			pPreStroke = &(pBN->pStroke[i-1]);
			pStroke->pPoint[0] = pPreStroke->pPoint[WSRS-1];
		}
		///////////// 0  //////////////////
		pPoint = pStroke->pPoint[0];
		if(i==0){
			pPoint->countParents = 0;
			pPoint->W[0] = (float*)malloc(sizeof(float));
			pPoint->W[1] = (float*)malloc(sizeof(float));
		}
		///////////// 1  //////////////////
		pPoint = pStroke->pPoint[1];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)(malloc(sizeof(PointModel*)*(pPoint->countParents)));
		pPoint->parent[0] = pStroke->pPoint[0];
		pPoint->parent[1] = pStroke->pPoint[2];
		pPoint->W[0] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));
		pPoint->W[1] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));

		///////////// 2  //////////////////
		pPoint = pStroke->pPoint[2];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)(malloc(sizeof(PointModel*)*(pPoint->countParents)));
		pPoint->parent[0] = pStroke->pPoint[0];
		pPoint->parent[1] = pStroke->pPoint[4];
		pPoint->W[0] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));
		pPoint->W[1] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));
		///////////// 3  //////////////////
		pPoint = pStroke->pPoint[3];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)(malloc(sizeof(PointModel*)*(pPoint->countParents)));

		pPoint->parent[0] = pStroke->pPoint[2];
		pPoint->parent[1] = pStroke->pPoint[4];
		pPoint->W[0] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));
		pPoint->W[1] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));

		///////////// 4  //////////////////
		pPoint = pStroke->pPoint[4];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)(malloc(sizeof(PointModel*)*(pPoint->countParents)));
		pPoint->parent[0] = pStroke->pPoint[0];
		pPoint->parent[1] = pStroke->pPoint[WSRS-1];
		pPoint->W[0] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));
		pPoint->W[1] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));

		///////////// 5  //////////////////
		pPoint = pStroke->pPoint[5];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)(malloc(sizeof(PointModel*)*(pPoint->countParents)));

		pPoint->parent[0] = pStroke->pPoint[4];
		pPoint->parent[1] = pStroke->pPoint[6];
		pPoint->W[0] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));
		pPoint->W[1] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));

		///////////// 6  //////////////////
		pPoint = pStroke->pPoint[6];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)(malloc(sizeof(PointModel*)*(pPoint->countParents)));

		pPoint->parent[0] = pStroke->pPoint[4];
		pPoint->parent[1] = pStroke->pPoint[WSRS-1];
		pPoint->W[0] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));
		pPoint->W[1] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));

		///////////// 7  //////////////////
		pPoint = pStroke->pPoint[7];
		pPoint->countParents = 2;
		pPoint->parent = (PointModel**)(malloc(sizeof(PointModel*)*(pPoint->countParents)));

		pPoint->parent[0] = pStroke->pPoint[6];
		pPoint->parent[1] = pStroke->pPoint[WSRS-1];
		pPoint->W[0] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));
		pPoint->W[1] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));

		///////////// 8  //////////////////
		pPoint = pStroke->pPoint[8];
		pPoint->countParents = i+1;
		pPoint->parent = (PointModel**)(malloc(sizeof(PointModel*)*(pPoint->countParents)));

		for(j=0;j<pPoint->countParents;j++){
			pPreStroke = &(pBN->pStroke[j]);
			pPoint->parent[j] = pPreStroke->pPoint[0];
		}
		pPoint->W[0] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));
		pPoint->W[1] = (float*)malloc(sizeof(float)*(pPoint->countParents*2+1));

	}
	return TRUE;
}
/*
_____________________________________________________________
  
Լ̸:		deleteBN   - BN 带 Ѵ.

 :		
		
ȯ:			BOOL TRUE: :False: 		
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/
BOOL CRecogCore::deleteBN(DigitBN *pBN)
{
	int StrkNum = pBN->StrokeNum;
	if(StrkNum<1)return FALSE;
	int i,j,st;
	StrokeModel* pStroke;
	PointModel* pPoint;
	for(i=0;i<pBN->StrokeNum;i++){
		pStroke = &(pBN->pStroke[i]);

		if(i==0 )st=0;
		else st=1;
		for(j=st;j<WSRS;j++){
			pPoint = pStroke->pPoint[j];
			if(pPoint->countParents>0)delete pPoint->parent;
			delete pPoint->W[0];
			delete pPoint->W[1];
			delete pStroke->pPoint[j];
		}
	}
	delete pBN->pStroke;
	return TRUE;
}
/*
_____________________________________________________________
  
Լ̸:		InitBN   - BN ־  ȹ   Ѵ.

 :		
		
ȯ:			BOOL TRUE: :False: 		
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/

BOOL CRecogCore::InitBN(DigitBN *pBN,int strokeNum,int charId)
{
	if(strokeNum < 1) return FALSE;
	pBN->CharId = charId;
	pBN->StrokeNum = strokeNum;
	pBN->pStroke = (StrokeModel*)malloc(sizeof(StrokeModel)*pBN->StrokeNum);
	BOOL b = CreateParentLink(pBN);
	return b;
}
/*
_____________________________________________________________
  
Լ̸:		LoadBN   - BN fileκ  Ѵ.

 :		
		
ȯ:			BOOL TRUE: :False: 		
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/

BOOL CRecogCore::LoadBN(DigitBN *pBN, FILE *file)
{
	StrokeModel* pStroke;
	PointModel* pPoint;
	int i,j,st,paNum;
	fread(&(pBN->CharId),sizeof(int),1,file);
	fread(&(pBN->StrokeNum),sizeof(int),1,file);
	if(pBN->StrokeNum < 1) return FALSE;
	pBN->pStroke = (StrokeModel*)malloc(sizeof(StrokeModel)*pBN->StrokeNum);


	CreateParentLink(pBN);
	for(i=0;i<pBN->StrokeNum;i++){
		pStroke = &(pBN->pStroke[i]);
		if(i==0 )st=0;
		else st=1;
		for(j=st;j<WSRS;j++){
			pPoint = pStroke->pPoint[j];
			fread(pPoint->ramda,sizeof(float),2,file);
			fread(pPoint->matrix,sizeof(float),2*2,file);
			paNum = pPoint->countParents;
			fread(pPoint->W[0],sizeof(float),(paNum*2+1),file);
			fread(pPoint->W[1],sizeof(float),(paNum*2+1),file);
			memset(pPoint->P,0,sizeof(float)*2);
		}
	}
	return TRUE;
}
/*
_____________________________________________________________
  
Լ̸:		SaveBN   - BN file 

 :		
		
ȯ:			BOOL TRUE: :False: 		
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/

BOOL CRecogCore::SaveBN(DigitBN *pBN, FILE *file)
{
	StrokeModel* pStroke;
	PointModel* pPoint;
	int i,j,st,paNum;
	if(pBN->StrokeNum < 1) return FALSE;
	fwrite(&(pBN->CharId),sizeof(int),1,file);
	fwrite(&(pBN->StrokeNum),sizeof(int),1,file);

	for(i=0;i<pBN->StrokeNum;i++){
		pStroke = &(pBN->pStroke[i]);
		if(i==0 )st=0;
		else st=1;
		for(j=st;j<WSRS;j++){
			pPoint = pStroke->pPoint[j];
			fwrite(pPoint->ramda,sizeof(float),2,file);
			fwrite(pPoint->matrix,sizeof(float),2*2,file);
			paNum = pPoint->countParents;
			fwrite(pPoint->W[0],sizeof(float),(paNum*2+1),file);
			fwrite(pPoint->W[1],sizeof(float),(paNum*2+1),file);
		}
	}
	return TRUE;
}
/*
_____________________________________________________________
  
Լ̸:		FowordBN   - BN  Ȯ 

 :		"Bayesian networkmodeling of strokes and their relationships
				 for on-line handwriting recognition"  
				 Pattern Recognition 37 (2004) 253 . 264
		
ȯ:			ȮŸ
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/

float CRecogCore::FowordBN(DigitBN *pBN)
{
	float dis=0.0f;
	int StrkNum = pBN->StrokeNum;
	if(StrkNum<1)return MAXDIS;
	int i;
	for(i=0;i<pBN->StrokeNum;i++){
		dis += FowordStroke(pBN,i);
	}
	return dis;
}
/*
_____________________________________________________________
  
Լ̸:		FowordStroke   - BN StrokeId° ȹ Ȯ 

 :		"Bayesian networkmodeling of strokes and their relationships
				 for on-line handwriting recognition"  
				 Pattern Recognition 37 (2004) 253 . 264
		
ȯ:			ȮŸ
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/
float CRecogCore::FowordStroke(DigitBN *pBN, int StrokeId)
{
	int StrkId = StrokeId;
	StrokeModel* pStroke = &(pBN->pStroke[StrkId]);
	PointModel* pPoint;
	int i,j,st;
	if(StrkId == 0) st = 0;
	else st = 1;
	float dis=0.0f;
	int ParNum;
	float mean[2],scala[2];
	for(i=st;i<WSRS;i++){
		pPoint = pStroke->pPoint[i];
		ParNum = pPoint->countParents;
		memset(&mean,0,sizeof(float)*2);
		for (j=0;j<ParNum;j++) {
			mean[0] += pPoint->W[0][j*2]*pPoint->parent[j]->P[0] + pPoint->W[0][j*2+1]*pPoint->parent[j]->P[1];
			mean[1] += pPoint->W[1][j*2]*pPoint->parent[j]->P[0] + pPoint->W[1][j*2+1]*pPoint->parent[j]->P[1];
		}
		mean[0] += pPoint->W[0][ParNum*2];
		mean[1] += pPoint->W[1][ParNum*2];

		mean[0] = pPoint->P[0] - mean[0];
		mean[1] = pPoint->P[1] - mean[1];
		
		scala[0] = pPoint->matrix[0][0]*mean[0] + pPoint->matrix[0][1]*mean[1];
		scala[1] = pPoint->matrix[1][0]*mean[0] + pPoint->matrix[1][1]*mean[1];

//		dis += scala[0]*mean[0] + scala[1]*mean[1];
//		dis += pPoint->ramda[0];

		dis += scala[0]*scala[0]/pPoint->ramda[0];//*ord[i];
		dis += scala[1]*scala[1]/pPoint->ramda[1];//*ord[i];

//		dis += (float)log(pPoint->ramda[0]);
//		dis += (float)log(pPoint->ramda[1]);
	}
	return dis;
}
/*
_____________________________________________________________
  
Լ̸:		SetDataInBN   - BN Ʈ  

 :		
		
ȯ:			BOOL TRUE: :False: 		
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/BOOL CRecogCore::SetDataInBN(DigitBN *pBN,OVR_POINT* pPts,int* pSelNo,int SelNum)
{
	if(SelNum!=pBN->StrokeNum+1) return FALSE;
	int i,st,ed;
	for(i=0;i<pBN->StrokeNum;i++){
		st = pSelNo[i];
		ed = pSelNo[i+1];
		SetDataInStroke(pBN,i,pPts,st,ed);
	}
	return TRUE;
}
/*
_____________________________________________________________
  
Լ̸:		SetDataInStroke   - BN StrokeId° ȹ Ʈ  

 :		
		
ȯ:			BOOL TRUE: :False: 		
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/
void CRecogCore::SetDataInStroke(DigitBN *pBN, int StrokeId,OVR_POINT* pPts,int st,int ed)
{
	int StrkId = StrokeId;
	StrokeModel* pStroke = &(pBN->pStroke[StrkId]);
	PointModel* pPoint;
	int i,no,nst;
	int len = (ed-st);
	int nodes = (WSRS-1);
	if(StrokeId == 0 ) nst=0;
	else nst = 1;
	for(i=nst;i<WSRS-1;i++){
		pPoint = pStroke->pPoint[i];
		no = st + (len*i)/nodes;// +0.5f);
		pPoint->P[0] = (float)pPts[no].nX;
		pPoint->P[1] = (float)pPts[no].nY;
	}
	pPoint = pStroke->pPoint[WSRS-1];
	pPoint->P[0] = (float)pPts[ed].nX;
	pPoint->P[1] = (float)pPts[ed].nY;
}
/*
_____________________________________________________________
  
Լ̸:		SetEndDataInStroke   - BN StrokeId° ȹ ۰  

 :		
		
ȯ:			
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/

void CRecogCore::SetEndDataInStroke(DigitBN *pBN, int StrokeId,OVR_POINT* pPts,int st,int ed)
{
	StrokeModel* pStroke = &(pBN->pStroke[StrokeId]);
	PointModel* pPoint;
	pPoint = pStroke->pPoint[0];
	pPoint->P[0] = (float)pPts[st].nX;
	pPoint->P[1] = (float)pPts[st].nY;
	pPoint = pStroke->pPoint[WSRS-1];
	pPoint->P[0] = (float)pPts[ed].nX;
	pPoint->P[1] = (float)pPts[ed].nY;
}
/*
_____________________________________________________________
  
Լ̸:		GetStrokeSegByDynamicProgram   - Ʈ (pPts) Ͽ ȹ Ͽ 
				BN   ο ׶ ȮŸ 

 :		"Bayesian networkmodeling of strokes and their relationships
				 for on-line handwriting recognition"  
				 Pattern Recognition 37 (2004) 253 . 264
		
ȯ:			ȮŸ
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/

float CRecogCore::GetStrokeSegByDynamicProgram(DigitBN *pBN,OVR_POINT* pPts,int* pSamNo,int& SamNum)
{
	int i,t,b,k,bb,st,ed;
	int StrkNum = pBN->StrokeNum;
	if(SamNum<StrkNum+1) return MAXDIS;

	float minDis,tempDis,Thdis = MAXDIS;//200.0f;//1000.0f;

	float (*dis)[MAXSAMNUM];
	BOOL (*flag)[MAXSAMNUM];
	int	(*path)[MAXSAMNUM][MAXSTROKENUM];
	dis = m_dis;
	flag = m_flag;
	path = m_path;
	memset(flag,0,sizeof(BOOL)*MAXSTROKENUM*MAXSAMNUM);
	dis[0][0] = 0;
	path[0][0][0] = pSamNo[0];
	dis[StrkNum-1][SamNum-1] = MAXDIS;
	for(t=1;t<SamNum;t++){
		st = max(t-(SamNum-StrkNum),0);
		if(t != SamNum-1) ed = min(t,StrkNum-1);
		else 
			ed=StrkNum;
		for(i=st;i<ed;i++){
			if(i==0){
				SetDataInStroke(pBN,0,pPts,pSamNo[0],pSamNo[t]);
				minDis = FowordStroke(pBN,0);
				//memcpy(path[0][t],path[0][0],sizeof(int));
				if(minDis>=Thdis) //Ÿ ſ ū   //////////////
					continue;
				dis[0][t] = minDis;
				path[0][t][0] = pSamNo[0];
				path[0][t][1] = pSamNo[t];
				flag[0][t] = TRUE;
				continue;
			}
			minDis = MAXDIS;
			bb=-1;
			for (b=1;b<t;b++) {
				if(flag[i-1][b] == FALSE) continue;
				for(k=0;k<i;k++)
					SetEndDataInStroke(pBN,k,pPts,path[i-1][b][k],path[i-1][b][k+1]);
				SetDataInStroke(pBN,i,pPts,pSamNo[b],pSamNo[t]);
				tempDis = FowordStroke(pBN,i)+dis[i-1][b];
				if(minDis>tempDis) {
					bb = b;
					minDis = tempDis;
				}
			}
			if(bb==-1)continue;
		
			if(minDis>=Thdis) //Ÿ ſ ū   //////////////
				continue;
			dis[i][t] = minDis;
			memcpy(path[i][t],path[i-1][bb],sizeof(int)*(i+1));
			path[i][t][i+1] = pSamNo[t];
			flag[i][t] = TRUE;
		}
	}

	float rdis = dis[StrkNum-1][SamNum-1];
	if(flag[StrkNum-1][SamNum-1] == TRUE){
		memcpy(pSamNo,path[StrkNum-1][SamNum-1],sizeof(int)*StrkNum+1);
		SamNum = StrkNum+1;
		SetDataInBN(pBN,pPts,pSamNo,SamNum);
//		for(k=0;k<StrkNum;k++)
//			SetDataInStroke(pBN,k,pPts,pSamNo[k],pSamNo[k+1]);
		return rdis;// /StrkNum;
	}else
		return MAXDIS;
}
/*
_____________________________________________________________
  
Լ̸:		LoadDic  - 

 :		
		
ȯ:			BOOL TRUE: :False: 		
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/

BOOL CRecogCore::LoadDic()
{

	int i;
	FILE* file= NULL;
	char filename[MAX_PATH];
	char szDicDir[] = "C:\\dglee\\work\\090420_OSS_ONLINE_OCR\\ν\\PadRecog2\\engin\\BN.dic";
	sprintf(filename,"%s",szDicDir);

	file=fopen(filename,"rb");
	if(file == NULL) return FALSE;
	EndDIC();
	
	fread(&BNNum,sizeof(int),1,file);  //BN   б
//	m_BN = new DigitBN[BNNum];
	m_BN = (DigitBN*)malloc(sizeof(DigitBN)*BNNum);
	for(i=0;i<BNNum;i++){
		LoadBN(&m_BN[i],file);
	}
	fclose(file);

	return TRUE;
}

void CRecogCore::EndDIC()
{
	if(m_BN!=NULL){
		for(int i=0;i<BNNum;i++) {
			deleteBN(&m_BN[i]);
		}
		delete m_BN;m_BN=NULL;
		BNNum = 0;
	}
	
}
