/*
 * Decompiled with CFR 0.152.
 */
package org.codemaru;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.codemaru.ComThread;
import org.codemaru.ConfigFactory;
import org.codemaru.ConsoleLog;
import org.codemaru.Log;

class ListenerThread
extends Thread {
    SocketChannel fromSockChannel = null;
    String serviceHost;
    int servicePort;
    static Log log = ConsoleLog.getInstance();

    public ListenerThread(SocketChannel fromSockChannel, String serviceHost, int servicePort) {
        this.fromSockChannel = fromSockChannel;
        this.serviceHost = serviceHost;
        this.servicePort = servicePort;
    }

    public void run() {
        ConfigFactory conf = ConfigFactory.getInstance();
        try {
            while (true) {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.fromSockChannel.socket().getInputStream()));
                log.debug("waiting readLine(id)...");
                String id = br.readLine();
                if (id == null) {
                    log.debug("id is null ");
                    try {
                        ListenerThread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
                if (id.length() == 0) {
                    log.debug("received alive packet");
                    continue;
                }
                log.debug("id = " + id);
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.connect(new InetSocketAddress(conf.getServerHost(), conf.getServerPort()));
                socketChannel.socket().getOutputStream().write(("C\n" + id + "\n").getBytes());
                socketChannel.socket().getOutputStream().flush();
                SocketChannel serviceSockChannel = SocketChannel.open();
                serviceSockChannel.connect(new InetSocketAddress(this.serviceHost, this.servicePort));
                ComThread thread = new ComThread(serviceSockChannel, socketChannel);
                thread.start();
            }
        }
        catch (IOException e) {
            log.info(e.getMessage());
            return;
        }
    }
}

