#ifndef __THREAD_LIBRARY_H__
#define __THREAD_LIBRARY_H__

#ifdef _WIN32
#include <windows.h>		// header for critical section
#else
#include <pthread.h>
#endif


#ifdef _WIN32
typedef CRITICAL_SECTION	MUTEX;
typedef HANDLE				HANDLE_THREAD;
#else
typedef	pthread_mutex_t		MUTEX;
typedef pthread_t			HANDLE_THREAD;
#endif

#ifdef _WIN32
#define MUTEX_DEFINE(m)	MUTEX m;
#else
#define MUTEX_DEFINE(m)	MUTEX m = PTHREAD_MUTEX_INITIALIZER;
#endif

int MutexCreateNew ( MUTEX *mu );
int MutexLock( MUTEX *mu );
int MutexUnlock( MUTEX *mu );
int MutexDestroy( MUTEX *mu );
int WaitForThread( HANDLE_THREAD hHandle );

#endif

