/**
	⺻  Ǵ Լ ̺귯̴.
	¼   ̸ "misc.cpp"   Ǿϴ  ùٸ  𸣰ڴ.
*/
#ifdef _WIN32
#include <winsock2.h>
#else
#include <errno.h>
#endif


#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#include "stdafx.h"		// include empty header file for precomplied header directive in MFC.


/**
	⺻  Ǵ Լ ̺귯
@input	formatted string
@output	error message
@note	 Լ #ifdef ũη  ȰؾѴ.
*/

void _dbg_out( char *format, ... )
{

//#ifdef _DEBUG
	char message[1024];
	int status, ec;
	va_list arglist;

	ec = 1;
	va_start(arglist, format);
	status = vsprintf( message, format, arglist );
	if(strlen( message ) + 1 > sizeof( message ) || status == EOF) {
		ec = 0;
		fprintf( stderr, "The message is too long or invalid.");
	}
	va_end(arglist);

	if ( ec )
		fprintf( stderr, "%s", message );
	fflush( stderr );
//#endif
}



/**
	NLSocket::ChkErr() Լ  ״ ؼ Ѵ.
*/
int	_print_errcode()
{

	
	char *msg="˼ ";
	int nError=0;
#ifdef _WIN32
	nError	= WSAGetLastError();

	if ( nError == 0 ) return false;
	switch ( nError )
	{
	case WSANOTINITIALISED	:
		msg = "WSAStartup Լ ȣ ʾҽϴ.";
		break;
	case WSAENETDOWN		:
		msg = "Ʈũ ٿ";
		break;
	case WSAEFAULT			:
		msg = "addrlen ڰ ";
		break;
	case WSAEINTR			:
		msg = "ƮƮ  ߴ";
		break;
	case WSAEINPROGRESS		:
		msg = "ŷ   1.1   ̰ų    ڰ ݹ Լ ó";
		break;

	case WSAEINVAL			:
		msg = "accept()  listen()  ";
		break;
	case WSAEISCONN			:
		msg = "  Դϴ.  Ǵ ޼ ݿ   Լ  Ͽ   ϴ.";
		break;
	case WSAENETRESET		:
		msg = "Ʈũ  缳Ǿϴ. ش ۾ Ǵ   ߻Ͽ  ϴ.";
		break;

	case WSAENOTSOCK		:
		msg = " ĺڰ ƴմϴ.";
		break;
	case WSAEMFILE			:
		msg = "  ť   ,   ִ  ĺڰ ";
		break;
	case WSAENOBUFS			:
		msg = " ";
		break;
	case WSAEOPNOTSUPP		:
		msg = "Ǵ   񽺸 ϴ  ƴ";
		break;
	case WSAEWOULDBLOCK		:
		msg = " ͺŷ   ε, ť ޾Ƶ   ʽϴ.";
		break;
	case WSAEMSGSIZE		:
		msg = "޽  ۺ ũ⶧ ʰиŭ ߷Ƚϴ.";
		break;
	case WSAETIMEDOUT		:
		msg = "Ʈũ  Ǵ Ǿ ý  ʾұ⶧  ϴ.";
		break;
	case WSAECONNRESET		:
		msg = " ǻ      ȸ  Ǿϴ.";
		break;
	case WSAEADDRNOTAVAIL	:
		msg = " ּҰ ȿ ʽϴ. , INADDR_ANY    ߽ϴ.";
		break;
	case 10057 :
		msg = "  ʾҽϴ.";
		break;
	}


	WSASetLastError( 0 );
#else

	nError = errno;

	switch ( nError )
	{
	case EWOULDBLOCK	:
		msg = "The  socket  is  marked non-blocking and no connec tions are present to be accepted. ";
		break;
	case EBADF		:
		msg = "The descriptor is invalid.";
		break;
	case ENOTSOCK		:
		msg = "The descriptor references a file, not a socket.";
		break;
	case EOPNOTSUPP		:
		msg = "The referenced socket is not of type SOCK_STREAM.";
		break;
	case EFAULT		:
		msg = "The addr parameter is not in a writable part of the user address space.";
		break;
	case EPERM		:
		msg = "Firewall rules forbid connection.";
		break;
	case ENOBUFS		:
	case ENOMEM		:
		msg = "Not  enough free memory.  This often means that the memory allocation is limited by the  socket  buffer limits, not by the system memory.";
		break;
	}
	errno=0;
	
#endif


#ifdef _WINDOWS
	if ( nError )
		TRACE("[%d] %s\n", nError, msg);
#else
	if ( nError )
		fprintf( stderr, "[%d] %s\n", nError, msg );
#endif
	msg = NULL;
	return false;
}






int _get_stamp()
{
	time_t stamp; time( &stamp );
	return stamp;
}
