/**
@file thread_library.cpp
@note
	(2003/07/06) ̺귯 Ÿ ؽ ؼ ȭ Ѵ.
@todo
	/Ŭ̾Ʈ ȯ濡     ؽ  䱸ȴ.
@todo
	ؽ ùٷ ϴ üũ. н ýۿ ǽ .

@note ؽ  
	 ۷ι  ܿ ϰ ʱȭϴ   .
	׷, MUTEX_DEFINE()   ϰ ʱȭѴ.
	 MUTEX_DEFINE()  ׳  Ѵ.
	MutexCreateNew()   ʱȭ Ѵ.

*/


#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "thread_library.h"
#include "stdafx.h"		// include empty header file for precomplied header directive in MFC.


/**
	Է¹ ؽ  ʱȭ Ѵ.
@note		 ڵ ؼ, ũη üߴ.
@note		 ɰ ϴ   Լ ϵ  Ѵ.
@attention	 Լ ַ   ( main() Լ )  ȣǴ° ˸´.
@attention	ϸ 0 Ѵ.
@return		ϸ mutex id, ϸ 0
*/

int MutexCreateNew(MUTEX *mu) {
#ifdef _WIN32
	InitializeCriticalSection( mu );
#else
	///@note recursive ؽ ƴϴ.
	//*mu = PTHREAD_MUTEX_INITIALIZER;
#endif
	return 0;
}

int MutexLock( MUTEX *mu )
{
#ifdef _WIN32
	EnterCriticalSection( mu );
#else
	int rc = pthread_mutex_lock( mu );
	/// check error
	if (rc) {
		perror("pthread_mutex_lock");
		pthread_exit(NULL);
	}
#endif
	return 0;
}

int MutexUnlock( MUTEX *mu )
{
#ifdef _WIN32
	LeaveCriticalSection( mu );
#else
	int rc = pthread_mutex_unlock( mu );
	if (rc) {
    perror("pthread_mutex_unlock");
    pthread_exit(NULL);
}
#endif
	return 0;
}


/**
@note	ؽ ָ ٸ 忡   .
@attention	ؽ Ŵ ()   ϴ° ƴ϶,  忡 ؾѴ.
*/
int MutexDestroy( MUTEX *mu )
{
#ifdef _WIN32
	DeleteCriticalSection( mu );
#else
	pthread_mutex_destroy( mu );
#endif
	return 0;
}

int WaitForThread( HANDLE_THREAD hHandle )
{
	
#ifdef _WIN32
	int rc;
	rc = WaitForSingleObject( hHandle, INFINITE );
	return rc;
#else
	int *rc;
	printf("about to pthread join for handle ( %d )\n", (int)hHandle);
	if ( ! pthread_join( hHandle, (void **)&rc ) ) {
		// error
		fprintf(stderr, \
			"[%d] error on pthread_join in WaitForThread()", errno);
		exit( 1 );
	}
	printf("pthread_join ok ( %d )\n", (int)hHandle);
	return *rc;
#endif
	
}

