#ifndef _I386_CACHE_H_
#define _I386_CACHE_H_

#include <toykernel/autoconf.h>

/*
 * i386, i486		- 4
 * i586, i686, PIII	- 5
 * Athlon			- 6
 * P4				- 7
 */
/*
 * default is i586 processor
 */
#ifdef CONFIG_M386
#define CONFIG_X86_L1_CHACHE_SHIFT	4
#endif
#ifdef CONFIG_M486
#define CONFIG_X86_L1_CHACHE_SHIFT	4
#endif
#ifdef CONFIG_M586
#define CONFIG_X86_L1_CHACHE_SHIFT	5
#endif
#ifdef CONFIG_M686
#define CONFIG_X86_L1_CHACHE_SHIFT	5
#endif
#ifdef CONFIG_MPENTIUMIII
#define CONFIG_X86_L1_CHACHE_SHIFT	5
#endif
#ifdef CONFIG_MPENTIUM4
#define CONFIG_X86_L1_CHACHE_SHIFT	7
#endif
#ifdef CONFIG_MK7
#define CONFIG_X86_L1_CHACHE_SHIFT	6
#endif

/* L1 cache line size */
#define L1_CACHE_SHIFT	(CONFIG_X86_L1_CACHE_SHIFT)
#define L1_CACHE_BYTES	(1 << L1_CACHE_SHIFT)

#endif
