#ifndef _I386_E820_H_
#define _I386_E820_H_

#define E820MAP			0x0a00
#define E820NR			0x0c80
#define E820MAX			32

#define SMAP			0x534d4150

/* e820 function memoty type */
#define E820_RAM		1
#define E820_RESERVED	2
#define E820_ACPI		3
#define E820_NVS		4

#define HIGH_MEMORY		(1024*1024)

#ifndef __ASSEMBLY__
struct e820_mem {
	unsigned long baseaddrlow;
	unsigned long baseaddrhigh;
	unsigned long lengthlow;
	unsigned long lengthhigh;
	unsigned long type;
};

struct e820map {
	int nr_map;
	struct e820entry {
		unsigned long long addr;
		unsigned long long size;
		unsigned long type;
	} map[E820MAX];
};

extern struct e820map e820;

#endif /* ! __ASSEMBLY__ */

#endif

