#ifndef _MM_H_
#define _MM_H_

#include <toykernel/init.h>
#include <arch/page.h>

#define PG_locked		 0	/* Page is locked. Don't touch. */
#define PG_error		 1
#define PG_referenced		 2
#define PG_uptodate		 3
#define PG_dirty		 4
#define PG_unused		 5
#define PG_lru			 6
#define PG_active		 7
#define PG_slab			 8
#define PG_skip			10
#define PG_highmem		11
#define PG_checked		12	/* kill me in 2.5.<early>. */
#define PG_arch_1		13
#define PG_reserved		14
#define PG_launder		15	/* written out by VM pressure.. */

typedef struct page {
	struct page *next;
	struct page *prev;
	int count;
} mem_map_t;

#define MAP_NR(addr)		((addr) >> PAGE_SHIFT)
#define page_address(page)	__va( (((page) -  mem_map) << PAGE_SHIFT) )

extern struct page * FASTCALL(__alloc_pages(unsigned int gfp_mask, unsigned int size));

#define alloc_pages(mask, order) __alloc_pages(mask, order)
#define alloc_page(gfp_mask) alloc_pages(gfp_mask, PAGE_SIZE)

extern unsigned long FASTCALL(__get_free_pages(unsigned int gfp_mask, unsigned int size));
extern unsigned long FASTCALL(get_zeroed_page(unsigned int gfp_mask));

#define __get_free_page(gfp_mask) \
		__get_free_pages((gfp_mask), PAGE_SIZE)

#define __get_dma_pages(gfp_mask, order) \
		__get_free_pages((gfp_mask) | GFP_DMA,(order))

#define get_free_page get_zeroed_page

extern void FASTCALL(__free_pages(struct page *page, unsigned int order));
extern void FASTCALL(free_pages(unsigned long addr, unsigned int order));

#define __free_page(page) __free_pages((page), 0)
#define free_page(addr) free_pages((addr),0)

/*
 * GFP bitmasks..
 */
#define __GFP_DMA	0x01
#define __GFP_HIGHMEM	0x02
#define __GFP_WAIT	0x10	/* Can wait and reschedule? */
#define __GFP_HIGH	0x20	/* Should access emergency pools? */
#define __GFP_IO	0x40	/* Can start low memory physical IO? */
#define __GFP_HIGHIO	0x80	/* Can start high mem physical IO? */
#define __GFP_FS	0x100	/* Can call down to low-level FS? */

#define GFP_NOHIGHIO	(__GFP_HIGH | __GFP_WAIT | __GFP_IO)
#define GFP_NOIO	(__GFP_HIGH | __GFP_WAIT)
#define GFP_NOFS	(__GFP_HIGH | __GFP_WAIT | __GFP_IO | __GFP_HIGHIO)
#define GFP_ATOMIC	(__GFP_HIGH)
#define GFP_USER	(             __GFP_WAIT | __GFP_IO | __GFP_HIGHIO | __GFP_FS)
#define GFP_HIGHUSER	(             __GFP_WAIT | __GFP_IO | __GFP_HIGHIO | __GFP_FS | __GFP_HIGHMEM)
#define GFP_KERNEL	(__GFP_HIGH | __GFP_WAIT | __GFP_IO | __GFP_HIGHIO | __GFP_FS)
#define GFP_NFS		(__GFP_HIGH | __GFP_WAIT | __GFP_IO | __GFP_HIGHIO | __GFP_FS)
#define GFP_KSWAPD	(             __GFP_WAIT | __GFP_IO | __GFP_HIGHIO | __GFP_FS)

#define GFP_DMA		__GFP_DMA

extern unsigned long max_low_pfn;
extern unsigned long min_low_pfn;
extern mem_map_t *mem_map;
extern int __init mem_map_init(void);

#endif

